/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.action;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;

public class FlyoutChangeLayoutAction
extends Action {
    private IEditorPart editor;
    private boolean checked;

    public FlyoutChangeLayoutAction(IEditorPart editor) {
        super("Automatic Layout", 2);
        this.editor = editor;
    }

    public void run() {
        if (this.editor instanceof ERDEditorPart) {
            EntityDiagram entityDiagram;
            ERDEditorPart erdEditor = (ERDEditorPart)this.editor;
            boolean isManual = (entityDiagram = erdEditor.getDiagram()).isLayoutManualDesired();
            entityDiagram.setLayoutManualDesired(!isManual);
            erdEditor.getDiagramPart().changeLayout();
            this.checked = !isManual;
            this.setChecked(this.checked);
        }
    }

    public boolean isChecked() {
        if (this.editor != null) {
            return this.isChecked(this.editor);
        }
        return super.isChecked();
    }

    public boolean isChecked(IEditorPart editor) {
        if (editor instanceof ERDEditorPart) {
            ERDEditorPart schemaEditor = (ERDEditorPart)editor;
            EntityDiagram entityDiagram = schemaEditor.getDiagram();
            boolean checkTrue = entityDiagram.isLayoutManualDesired();
            return !checkTrue;
        }
        return false;
    }

    public void setActiveEditor(IEditorPart editor) {
        this.editor = editor;
        boolean localChecked = this.isChecked(editor);
        if (localChecked) {
            this.firePropertyChange("checked", Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange("checked", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

