/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

public class ResultSetHandlerOpenWith
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(ResultSetHandlerOpenWith.class);
    public static final String CMD_OPEN_WITH = "org.jkiss.dbeaver.core.resultset.openWith";
    public static final String PARAM_PROCESSOR_ID = "processorId";
    public static final String PARAM_ACTIVE_APP = "org.jkiss.dbeaver.core.resultset.openWith.currentApp";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        DataTransferProcessorDescriptor processor = ResultSetHandlerOpenWith.getActiveProcessor(event.getParameter(PARAM_PROCESSOR_ID));
        if (processor == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.openWith": {
                ResultSetHandlerOpenWith.openResultsWith(resultSet, processor);
            }
        }
        return null;
    }

    static DataTransferProcessorDescriptor getActiveProcessor(String processorId) {
        if (CommonUtils.isEmpty((String)processorId)) {
            processorId = DBWorkbench.getPlatform().getPreferenceStore().getString(PARAM_ACTIVE_APP);
        }
        if (CommonUtils.isEmpty((String)processorId)) {
            DataTransferProcessorDescriptor defaultAppProcessor = ResultSetHandlerOpenWith.getDefaultProcessor();
            if (defaultAppProcessor != null) {
                return defaultAppProcessor;
            }
        } else {
            return DataTransferRegistry.getInstance().getProcessor(processorId);
        }
        return null;
    }

    static DataTransferProcessorDescriptor getDefaultProcessor() {
        DataTransferProcessorDescriptor defaultAppProcessor = ResultSetHandlerOpenWith.getDefaultAppProcessor();
        if (defaultAppProcessor != null) {
            return defaultAppProcessor;
        }
        return null;
    }

    private static void openResultsWith(final IResultSetController resultSet, final DataTransferProcessorDescriptor processor) {
        ResultSetDataContainer dataContainer;
        final ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        IResultSetSelection rsSelection = resultSet.getSelection();
        List<ResultSetRow> rsSelectedRows = rsSelection.getSelectedRows();
        List<DBDAttributeBinding> rsSelectedAttributes = rsSelection.getSelectedAttributes();
        if (rsSelectedRows.size() > 1 || rsSelectedAttributes.size() > 1) {
            ArrayList<Long> selectedRows = new ArrayList<Long>();
            for (ResultSetRow selectedRow : rsSelectedRows) {
                selectedRows.add(Long.valueOf(selectedRow.getRowNumber()));
            }
            ArrayList<String> selectedAttributes = new ArrayList<String>();
            for (DBDAttributeBinding attributeBinding : rsSelectedAttributes) {
                selectedAttributes.add(attributeBinding.getName());
            }
            options.setSelectedRows(selectedRows);
            options.setSelectedColumns(selectedAttributes);
        }
        if ((dataContainer = new ResultSetDataContainer(resultSet.getDataContainer(), resultSet.getModel(), options)).getDataSource() == null) {
            DBWorkbench.getPlatformUI().showError("Open " + processor.getAppName(), ModelMessages.error_not_connected_to_database);
            return;
        }
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        String prevActiveApp = preferenceStore.getString(PARAM_ACTIVE_APP);
        CommonUtils.equalObjects((Object)prevActiveApp, (Object)processor.getFullId());
        AbstractJob exportJob = new AbstractJob("Open " + processor.getAppName()){
            {
                super($anonymous0);
                this.setUser(true);
                this.setSystem(false);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    File tempDir = DBWorkbench.getPlatform().getTempFolder(monitor, "data-files");
                    File tempFile = new File(tempDir, String.valueOf(new SimpleDateFormat("yyyyMMdd-HHmmss").format(System.currentTimeMillis())) + "." + processor.getAppFileExtension());
                    tempFile.deleteOnExit();
                    IDataTransferProcessor processorInstance = processor.getInstance();
                    if (!(processorInstance instanceof IStreamDataExporter)) {
                        return Status.CANCEL_STATUS;
                    }
                    IStreamDataExporter exporter = (IStreamDataExporter)processorInstance;
                    StreamTransferConsumer consumer = new StreamTransferConsumer();
                    StreamConsumerSettings settings = new StreamConsumerSettings();
                    settings.setOutputEncodingBOM(false);
                    settings.setOpenFolderOnFinish(false);
                    settings.setOutputFolder(tempDir.getAbsolutePath());
                    settings.setOutputFilePattern(tempFile.getName());
                    HashMap<Object, Object> properties = new HashMap<Object, Object>();
                    for (DBPPropertyDescriptor prop : processor.getProperties()) {
                        properties.put(prop.getId(), prop.getDefaultValue());
                    }
                    properties.remove("extension");
                    consumer.initTransfer((DBSObject)dataContainer, settings, new IDataTransferConsumer.TransferParameters(processor.isBinaryFormat()), exporter, properties);
                    DBDDataFilter dataFilter = resultSet.getModel().getDataFilter();
                    DatabaseTransferProducer producer = new DatabaseTransferProducer((DBSDataContainer)dataContainer, dataFilter);
                    DatabaseProducerSettings producerSettings = new DatabaseProducerSettings();
                    producerSettings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    producerSettings.setQueryRowCount(false);
                    producerSettings.setSelectedRowsOnly(!CommonUtils.isEmpty(options.getSelectedRows()));
                    producerSettings.setSelectedColumnsOnly(!CommonUtils.isEmpty(options.getSelectedColumns()));
                    producer.transferData(monitor, (IDataTransferConsumer)consumer, null, producerSettings);
                    consumer.finishTransfer(monitor, false);
                    UIUtils.asyncExec(() -> {
                        if (!UIUtils.launchProgram((String)tempFile.getAbsolutePath())) {
                            DBWorkbench.getPlatformUI().showError("Open " + processor.getAppName(), "Can't open " + processor.getAppFileExtension() + " file '" + tempFile.getAbsolutePath() + "'");
                        }
                    });
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Error opening in " + processor.getAppName(), null, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        exportJob.schedule();
    }

    public void updateElement(UIElement element, Map parameters) {
        DataTransferProcessorDescriptor processor = ResultSetHandlerOpenWith.getActiveProcessor((String)parameters.get(PARAM_PROCESSOR_ID));
        if (processor != null) {
            element.setText(processor.getAppName());
            if (!CommonUtils.isEmpty((String)processor.getDescription())) {
                element.setTooltip(processor.getDescription());
            }
            if (processor.getIcon() != null) {
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)processor.getIcon()));
            }
        }
    }

    private static DataTransferProcessorDescriptor getDefaultAppProcessor() {
        ArrayList<DataTransferProcessorDescriptor> processors = new ArrayList<DataTransferProcessorDescriptor>();
        for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getNodes(DataTransferNodeDescriptor.NodeType.CONSUMER)) {
            for (DataTransferProcessorDescriptor processor : consumerNode.getProcessors()) {
                if (processor.getAppFileExtension() == null) continue;
                processors.add(processor);
            }
        }
        processors.sort(Comparator.comparingInt(DataTransferProcessorDescriptor::getOrder));
        return processors.isEmpty() ? null : (DataTransferProcessorDescriptor)processors.get(0);
    }

    public static class OpenWithMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (rsv == null) {
                return new IContributionItem[0];
            }
            MenuManager menu = new MenuManager();
            rsv.fillOpenWithMenu((ContributionManager)menu);
            return menu.getItems();
        }
    }

    public static class OpenWithParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getNodes(DataTransferNodeDescriptor.NodeType.CONSUMER)) {
                for (DataTransferProcessorDescriptor processor : consumerNode.getProcessors()) {
                    if (processor.getAppFileExtension() == null) continue;
                    values.put(processor.getAppName(), processor.getFullId());
                }
            }
            return values;
        }
    }
}

