/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import scala.tools.fusesource_embedded.jansi.AnsiConsole;
import scala.tools.fusesource_embedded.jansi.AnsiOutputStream;
import scala.tools.fusesource_embedded.jansi.WindowsAnsiOutputStream;
import scala.tools.jline_embedded.WindowsTerminal;
import scala.tools.jline_embedded.internal.Configuration;

public class AnsiWindowsTerminal
extends WindowsTerminal {
    private final boolean ansiSupported = AnsiWindowsTerminal.detectAnsiSupport();

    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return AnsiWindowsTerminal.wrapOutputStream(out);
    }

    private static OutputStream wrapOutputStream(OutputStream stream) {
        if (Configuration.isWindows()) {
            try {
                return new WindowsAnsiOutputStream(stream);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream);
            }
        }
        return stream;
    }

    private static boolean detectAnsiSupport() {
        OutputStream out = AnsiConsole.wrapOutputStream(new ByteArrayOutputStream());
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out instanceof WindowsAnsiOutputStream;
    }

    public boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    public boolean hasWeirdWrap() {
        return false;
    }
}

