S2 = Manifold(2, 'S^2', structure='topological')
U = S2.open_subset('U'); V = S2.open_subset('V'); S2.declare_union(U,V)
c_xy = U.chart('x y'); x, y = c_xy[:]
c_uv = V.chart('u v'); u, v = c_uv[:]
xy_to_uv = c_xy.transition_map(c_uv, (x/(x**2+y**2), y/(x**2+y**2)),
                  intersection_name='W', restrictions1= x**2+y**2!=0,
                  restrictions2= u**2+v**2!=0)
uv_to_xy = xy_to_uv.inverse()
c_uvW = c_uv.restrict(U.intersection(V))
gSN1 = c_uvW.plot(c_xy, ranges={u:[-6.,-0.02], v:[-6.,-0.02]})
gSN2 = c_uvW.plot(c_xy, ranges={u:[-6.,-0.02], v:[0.02,6.]})
gSN3 = c_uvW.plot(c_xy, ranges={u:[0.02,6.], v:[-6.,-0.02]})
gSN4 = c_uvW.plot(c_xy, ranges={u:[0.02,6.], v:[0.02,6.]})
g = gSN1+gSN2+gSN3+gSN4; g.set_axes_range(-1.5, 1.5, -1.5, 1.5)
sphinx_plot(g)