/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.VcsError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRepository;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitOutgoingCommitsProvider
extends OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final Project myProject;

    public GitOutgoingCommitsProvider(@NotNull Project project) {
        if (project == null) {
            GitOutgoingCommitsProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public OutgoingResult getOutgoingCommits(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec, boolean initial) {
        OutgoingResult outgoingResult;
        block5: {
            GitLocalBranch branch;
            if (repository == null) {
                GitOutgoingCommitsProvider.$$$reportNull$$$0(1);
            }
            if (pushSpec == null) {
                GitOutgoingCommitsProvider.$$$reportNull$$$0(2);
            }
            String source = (branch = ((GitPushSource)pushSpec.getSource()).getBranch()).equals(repository.getCurrentBranch()) ? "HEAD" : branch.getFullName();
            GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
            String destination = target.getBranch().getFullName();
            try {
                List<GitCommit> commits2 = !target.isNewBranchCreated() ? GitHistoryUtils.history(this.myProject, repository.getRoot(), destination + ".." + source) : GitHistoryUtils.history(this.myProject, repository.getRoot(), source, "--not", "--remotes=" + target.getBranch().getRemote().getName(), "--max-count=1000");
                outgoingResult = new OutgoingResult(commits2, Collections.emptyList());
                if (outgoingResult != null) break block5;
            }
            catch (VcsException e) {
                OutgoingResult outgoingResult2 = new OutgoingResult(Collections.emptyList(), Collections.singletonList(new VcsError(GitUtil.cleanupErrorPrefixes(e.getMessage()))));
                if (outgoingResult2 == null) {
                    GitOutgoingCommitsProvider.$$$reportNull$$$0(4);
                }
                return outgoingResult2;
            }
            GitOutgoingCommitsProvider.$$$reportNull$$$0(3);
        }
        return outgoingResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpec";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitOutgoingCommitsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitOutgoingCommitsProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingCommits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutgoingCommits";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

