/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FindUsagesHelper {
    FindUsagesHelper() {
    }

    static boolean processUsagesInText(@NotNull PsiElement element, @NotNull Collection<String> stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<? super UsageInfo> processor2) {
        if (element == null) {
            FindUsagesHelper.$$$reportNull$$$0(0);
        }
        if (stringToSearch == null) {
            FindUsagesHelper.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            FindUsagesHelper.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            FindUsagesHelper.$$$reportNull$$$0(3);
        }
        TextRange elementTextRange = (TextRange)ReadAction.compute(() -> !element.isValid() || element instanceof PsiCompiledElement ? null : element.getTextRange());
        UsageInfoFactory factory = (usage, startOffset, endOffset) -> {
            if (!element.isValid()) {
                return new UsageInfo(usage, startOffset, endOffset, true);
            }
            if (elementTextRange != null && usage.getContainingFile() == element.getContainingFile() && elementTextRange.contains(startOffset) && elementTextRange.contains(endOffset)) {
                return null;
            }
            PsiReference someReference = usage.findReferenceAt(startOffset);
            if (someReference != null) {
                PsiElement refElement = someReference.getElement();
                for (PsiReference ref : PsiReferenceService.getService().getReferences(refElement, new PsiReferenceService.Hints(element, null))) {
                    if (!element.getManager().areElementsEquivalent(ref.resolve(), element)) continue;
                    TextRange range2 = ref.getRangeInElement().shiftRight(refElement.getTextRange().getStartOffset() - usage.getTextRange().getStartOffset());
                    return new UsageInfo(usage, range2.getStartOffset(), range2.getEndOffset(), true);
                }
            }
            return new UsageInfo(usage, startOffset, endOffset, true);
        };
        for (String s : stringToSearch) {
            if (PsiSearchHelperImpl.processTextOccurrences(element, s, searchScope, processor2, factory)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stringToSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/find/findUsages/FindUsagesHelper";
        objectArray[2] = "processUsagesInText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

