/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements DataProvider,
CopyProvider {
    public static final DataKey<TestFrameworkRunningModel> MODEL_DATA_KEY = DataKey.create((String)"testFrameworkModel.dataId");
    private TestFrameworkRunningModel myModel;

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    protected TestFrameworkRunningModel getTestFrameworkRunningModel() {
        return this.myModel;
    }

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 1) {
            return null;
        }
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model.getRoot())));
        this.getSelectionModel().setSelectionMode(model.getProperties().getSelectionMode());
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)this.myModel.getRoot());
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        int iconHeight = PoolOfTestIcons.PASSED_ICON.getIconHeight();
        this.setRowHeight(Math.max(fontHeight, iconHeight) + 2);
        this.setLargeModel(true);
    }

    public Object getData(@NotNull String dataId) {
        TreePath[] paths;
        if (dataId == null) {
            TestTreeView.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<PsiElement> els = new ArrayList<PsiElement>(paths.length);
            for (TreePath path2 : paths) {
                PsiElement psiElement;
                AbstractTestProxy test;
                if (this.isPathSelected(path2.getParentPath()) || (test = this.getSelectedTest(path2)) == null || (psiElement = (PsiElement)TestsUIUtil.getData(test, CommonDataKeys.PSI_ELEMENT.getName(), this.myModel)) == null) continue;
                els.add(psiElement);
            }
            return els.isEmpty() ? null : els.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (Location.DATA_KEYS.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<Location> locations = new ArrayList<Location>(paths.length);
            for (TreePath path3 : paths) {
                Location location;
                AbstractTestProxy test;
                if (this.isPathSelected(path3.getParentPath()) || (test = this.getSelectedTest(path3)) == null || (location = (Location)TestsUIUtil.getData(test, Location.DATA_KEY.getName(), this.myModel)) == null) continue;
                locations.add(location);
            }
            return locations.isEmpty() ? null : locations.toArray(new Location[0]);
        }
        if (AbstractTestProxy.DATA_KEYS.is(dataId) && (paths = this.getSelectionPaths()) != null) {
            return Arrays.stream(paths).map(path -> this.getSelectedTest((TreePath)path)).filter(Objects::nonNull).toArray(AbstractTestProxy[]::new);
        }
        if (MODEL_DATA_KEY.is(dataId)) {
            return this.myModel;
        }
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return null;
        }
        try {
            return TestsUIUtil.getData(testProxy, dataId, this.myModel);
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    public void performCopy(@NotNull DataContext dataContext) {
        AbstractTestProxy selectedTest;
        PsiElement element;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(1);
        }
        String fqn = (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null ? CopyReferenceAction.elementToFqn(element) : ((selectedTest = this.getSelectedTest()) != null ? selectedTest.getLocationUrl() : null);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(fqn));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        AbstractTestProxy test;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(2);
        }
        return (test = this.getSelectedTest()) != null && test.getLocationUrl() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<? super TreePath, String>)((Convertor)path -> {
            AbstractTestProxy testProxy = this.getSelectedTest((TreePath)path);
            if (testProxy == null) {
                return null;
            }
            return this.getPresentableName(testProxy);
        }));
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
        HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), obj -> {
            Object element;
            Object userObject;
            if (obj instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof NodeDescriptor && (element = ((NodeDescriptor)userObject).getElement()) instanceof AbstractTestProxy) {
                return (PsiElement)TestsUIUtil.getData((AbstractTestProxy)element, CommonDataKeys.PSI_ELEMENT.getName(), this.myModel);
            }
            return null;
        });
    }

    protected String getPresentableName(AbstractTestProxy testProxy) {
        return testProxy.getName();
    }

    public boolean isExpandableHandlerVisibleForCurrentRow(int row2) {
        ExpandableItemsHandler handler2 = this.getExpandableItemsHandler();
        Collection items = handler2.getExpandedItems();
        return items.size() == 1 && row2 == (Integer)items.iterator().next();
    }

    public void paint(Graphics g) {
        super.paint(g);
        TestFrameworkRunningModel model = this.myModel;
        if (model == null) {
            return;
        }
        TestConsoleProperties properties = model.getProperties();
        if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)properties)) {
            int firstRow;
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle clip = g.getClipBounds();
            int visibleRowCount = TreeUtil.getVisibleRowCountForFixedRowHeight((JTree)((Object)this));
            for (int row2 = firstRow = this.getClosestRowForLocation(0, visibleRect.y); row2 < Math.min(firstRow + visibleRowCount + 1, this.getRowCount()); ++row2) {
                Object testProxy;
                String durationString;
                Object data;
                Object node;
                if (this.isExpandableHandlerVisibleForCurrentRow(row2) || row2 == -1 || !((node = this.getPathForRow(row2).getLastPathComponent()) instanceof DefaultMutableTreeNode) || !((data = ((DefaultMutableTreeNode)node).getUserObject()) instanceof BaseTestProxyNodeDescriptor) || (durationString = ((AbstractTestProxy)(testProxy = ((BaseTestProxyNodeDescriptor)((Object)data)).getElement())).getDurationString(properties)) == null) continue;
                Rectangle rowBounds = this.getRowBounds(row2);
                rowBounds.x = 0;
                rowBounds.width = Integer.MAX_VALUE;
                if (!rowBounds.intersects(clip)) continue;
                Rectangle fullRowRect = new Rectangle(visibleRect.x, rowBounds.y, visibleRect.width, rowBounds.height);
                boolean rowSelected = this.isRowSelected(row2);
                boolean hasTreeFocus = this.hasFocus();
                TestTreeView.paintRowData(this, durationString, fullRowRect, (Graphics2D)g, rowSelected, hasTreeFocus);
            }
        }
    }

    private static void paintRowData(Tree tree, String duration, Rectangle bounds2, Graphics2D g, boolean isSelected, boolean hasFocus) {
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
        g.setFont(tree.getFont().deriveFont(0, UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        FontMetrics metrics = tree.getFontMetrics(g.getFont());
        int totalWidth = metrics.stringWidth(duration) + 2;
        int x = bounds2.x + bounds2.width - totalWidth;
        g.setColor(isSelected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : UIUtil.getTreeBackground());
        int leftOffset = 5;
        g.fillRect(x - 5, bounds2.y, totalWidth + 5, bounds2.height);
        g.translate(0, bounds2.y - 1);
        if (isSelected) {
            g.setColor(UIUtil.getTreeSelectionForeground((boolean)hasFocus));
        } else {
            g.setColor((Color)new JBColor(0x808080, 0x808080));
        }
        g.drawString(duration, x, SimpleColoredComponent.getTextBaseLine((FontMetrics)tree.getFontMetrics(tree.getFont()), (int)bounds2.height) + 1);
        g.translate(0, -bounds2.y + 1);
        config2.restore();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/TestTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

