/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.protocol;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.configuration.IpnbSettings;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbHtmlOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbJpegOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbLatexOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbPngOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbStreamOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbSvgOutputCell;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnectionListener;

public class IpnbConnection {
    private static final Logger LOG = Logger.getInstance(IpnbConnection.class);
    protected static final String API_URL = "/api";
    protected static final String KERNELS_URL = "/api/kernels";
    private static final String DEFAULT_LOGIN_PATH = "/login";
    private static final String KERNEL_SPECS_PATH = "/kernelspecs";
    private static final String SESSIONS_PATH = "/sessions";
    private static final String USER_PATH = "/user";
    private static final String HUB_PREFIX = "/hub";
    private static final String XSRF_TOKEN_HEADER = "X-XSRFToken";
    private static final String USERNAME_PARAMETER = "username";
    private static final String PASSWORD_PARAMETER = "password";
    private static final String XSRF_PARAMETER = "_xsrf";
    private static final String DEFAULT_KERNEL_SPEC_NAME = "default";
    private static final String TREE_PATH = "/tree";
    private static final int ATTEMPT_TO_CONNECT_NUMBER = 10;
    public static final String AUTHENTICATION_NEEDED = "Authentication needed";
    public static final String UNABLE_LOGIN_MESSAGE = "Unable to login: ";
    public static final String CANNOT_START_JUPYTER = "Cannot start Jupyter Notebook";
    @NotNull
    protected final URI myURI;
    @NotNull
    protected final String myKernelId;
    @NotNull
    protected final String mySessionId;
    @NotNull
    protected final IpnbConnectionListener myListener;
    @Nullable
    private final String myToken;
    private boolean myIsHubServer;
    private final Project myProject;
    private WebSocketClient myShellClient;
    private WebSocketClient myIOPubClient;
    private Thread myShellThread;
    private Thread myIOPubThread;
    private volatile boolean myIsShellOpen;
    private volatile boolean myIsIOPubOpen;
    protected volatile boolean myIsOpened;
    private IpnbOutputCell myOutput;
    private int myExecCount;
    private String myXsrf;
    private final HashMap<String, String> myHeaders;
    private final CookieManager myCookieManager;

    public IpnbConnection(@NotNull String uri, @NotNull IpnbConnectionListener listener, @Nullable String token, @NotNull Project project, @NotNull String pathToFile) throws IOException, URISyntaxException {
        if (uri == null) {
            IpnbConnection.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            IpnbConnection.$$$reportNull$$$0(1);
        }
        if (project == null) {
            IpnbConnection.$$$reportNull$$$0(2);
        }
        if (pathToFile == null) {
            IpnbConnection.$$$reportNull$$$0(3);
        }
        this.myIsHubServer = false;
        this.myIsShellOpen = false;
        this.myIsIOPubOpen = false;
        this.myIsOpened = false;
        this.myHeaders = new HashMap();
        this.myURI = new URI(uri);
        this.myListener = listener;
        this.myToken = token;
        this.myProject = project;
        this.myCookieManager = new CookieManager();
        CookieHandler.setDefault(this.myCookieManager);
        if (this.isRemote()) {
            String loginUrl = this.getLoginUrl();
            this.initXSRF(this.myURI.toString() + loginUrl);
            this.myIsHubServer = IpnbConnection.isHubServer(loginUrl);
            this.myKernelId = this.authorizeAndGetKernel(project, pathToFile, loginUrl);
            this.mySessionId = this.myHeaders.get("Cookie");
        } else {
            this.initXSRF(this.myURI.toString());
            if (this.myToken != null) {
                this.myHeaders.put("Authorization", "token " + this.myToken);
            }
            this.myKernelId = this.startKernel();
            this.mySessionId = UUID.randomUUID().toString();
        }
        this.initializeClients();
    }

    private boolean isRemote() {
        return "https".equals(this.myURI.getScheme());
    }

    private String authorizeAndGetKernel(@NotNull Project project, @NotNull String pathToFile, @NotNull String loginUrl) throws IOException {
        if (project == null) {
            IpnbConnection.$$$reportNull$$$0(4);
        }
        if (pathToFile == null) {
            IpnbConnection.$$$reportNull$$$0(5);
        }
        if (loginUrl == null) {
            IpnbConnection.$$$reportNull$$$0(6);
        }
        IpnbSettings ipnbSettings = IpnbSettings.getInstance(project);
        String username = ipnbSettings.getUsername();
        String cookies = this.login(username, ipnbSettings.getPassword(this.myProject.getLocationHash()), loginUrl);
        this.myHeaders.put("Cookie", cookies);
        if (this.myIsHubServer) {
            boolean started;
            if (this.myXsrf == null) {
                this.initXSRF(this.myURI.toString() + USER_PATH + "/" + username + TREE_PATH);
            }
            if (!(started = this.startJupyterNotebookServer(username))) {
                throw new IOException(CANNOT_START_JUPYTER);
            }
        }
        String kernelName = this.getDefaultKernelName();
        return this.getExistingKernelForSession(pathToFile, kernelName);
    }

    private boolean startJupyterNotebookServer(@NotNull String username) throws IOException {
        if (username == null) {
            IpnbConnection.$$$reportNull$$$0(7);
        }
        String serverStartUrl = "/user/" + username;
        for (int i = 0; i < 10; ++i) {
            String locationPrefix = "/user/" + username + TREE_PATH;
            String location = this.getLocation(this.myURI + serverStartUrl);
            if (location != null && location.startsWith(locationPrefix)) {
                return true;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getLocation(@NotNull String url) throws IOException {
        URLConnection urlConnection;
        if (url == null) {
            IpnbConnection.$$$reportNull$$$0(8);
        }
        if ((urlConnection = new URL(url).openConnection()) instanceof HttpURLConnection) {
            HttpURLConnection connection = this.configureConnection((HttpURLConnection)urlConnection, HTTPMethod.GET.name());
            try {
                String string = connection.getHeaderField("Location");
                return string;
            }
            finally {
                connection.disconnect();
            }
        }
        return "";
    }

    private static boolean isHubServer(@NotNull String redirectUrl) {
        if (redirectUrl == null) {
            IpnbConnection.$$$reportNull$$$0(9);
        }
        return redirectUrl.startsWith(HUB_PREFIX);
    }

    private void configureHttpsConnection() {
        HttpsURLConnection.setDefaultSSLSocketFactory(CertificateManager.getInstance().getSslContext().getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession session) {
                return IpnbConnection.this.myURI.getHost().equals(s);
            }
        });
    }

    private String login(@NotNull String username, @NotNull String password, @NotNull String loginUrl) throws IOException {
        if (username == null) {
            IpnbConnection.$$$reportNull$$$0(10);
        }
        if (password == null) {
            IpnbConnection.$$$reportNull$$$0(11);
        }
        if (loginUrl == null) {
            IpnbConnection.$$$reportNull$$$0(12);
        }
        String urlParameters = null;
        try {
            urlParameters = new URIBuilder().addParameter(XSRF_PARAMETER, this.myXsrf).addParameter(USERNAME_PARAMETER, username).addParameter(PASSWORD_PARAMETER, password).build().toString();
        }
        catch (URISyntaxException e) {
            LOG.warn(e.getMessage());
        }
        if (urlParameters == null) {
            throw new IOException("Unable to login");
        }
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        HttpsURLConnection connection = (HttpsURLConnection)ObjectUtils.tryCast((Object)this.configureConnection((HttpURLConnection)new URL(this.myURI + loginUrl).openConnection(), HTTPMethod.POST.name()), HttpsURLConnection.class);
        if (connection != null) {
            List<HttpCookie> cookies;
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            try (DataOutputStream wr = new DataOutputStream(outputStream);){
                wr.write(postData);
                wr.flush();
            }
            connection.connect();
            int code = connection.getResponseCode();
            if (code != 403 && code != 401 && !(cookies = this.myCookieManager.getCookieStore().getCookies()).isEmpty()) {
                return cookies.stream().map(cookie -> cookie.getName() + "=" + cookie.getValue()).collect(Collectors.joining(";"));
            }
        }
        String message = connection == null ? "" : connection.getResponseCode() + " " + connection.getResponseMessage();
        throw new IOException(UNABLE_LOGIN_MESSAGE + message);
    }

    private String getDefaultKernelName() {
        try {
            String response = this.httpRequest(this.createApiUrl(KERNEL_SPECS_PATH), HTTPMethod.GET.name());
            JsonObject kernelSpecs = (JsonObject)ObjectUtils.tryCast((Object)new JsonParser().parse(response), JsonObject.class);
            if (kernelSpecs != null && kernelSpecs.has(DEFAULT_KERNEL_SPEC_NAME)) {
                return kernelSpecs.get(DEFAULT_KERNEL_SPEC_NAME).getAsString();
            }
            LOG.warn("Got wrong kernel specs: " + response);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage());
        }
        return "";
    }

    @NotNull
    private String createApiUrl(@NotNull String path) {
        if (path == null) {
            IpnbConnection.$$$reportNull$$$0(13);
        }
        String apiPrefix = this.myIsHubServer ? "/user/" + IpnbSettings.getInstance(this.myProject).getUsername() : "";
        String string = this.myURI + apiPrefix + API_URL + path;
        if (string == null) {
            IpnbConnection.$$$reportNull$$$0(14);
        }
        return string;
    }

    private String getExistingKernelForSession(@NotNull String pathToFile, @NotNull String kernelName) throws IOException {
        byte[] postData;
        String wrapper;
        if (pathToFile == null) {
            IpnbConnection.$$$reportNull$$$0(15);
        }
        if (kernelName == null) {
            IpnbConnection.$$$reportNull$$$0(16);
        }
        if ((wrapper = this.getKernelId(postData = IpnbConnection.createNewFormatKernelPostParameters(pathToFile, kernelName))) == null) {
            byte[] oldParamsToPost = IpnbConnection.createOldFormatKernelPostParameters(pathToFile, kernelName);
            wrapper = this.getKernelId(oldParamsToPost);
        }
        return wrapper;
    }

    @Nullable
    private String getKernelId(byte[] postData) throws IOException {
        HttpsURLConnection httpsConnection;
        URLConnection connection = new URL(this.createApiUrl(SESSIONS_PATH)).openConnection();
        if (connection instanceof HttpsURLConnection && (httpsConnection = (HttpsURLConnection)ObjectUtils.tryCast((Object)this.configureConnection((HttpURLConnection)connection, HTTPMethod.POST.name()), HttpsURLConnection.class)) != null) {
            httpsConnection.setRequestProperty("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            httpsConnection.setRequestProperty("Content-Length", Integer.toString(postData.length));
            httpsConnection.setUseCaches(false);
            httpsConnection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            try (DataOutputStream wr = new DataOutputStream(outputStream);){
                wr.write(postData);
                wr.flush();
            }
            httpsConnection.connect();
            if (httpsConnection.getResponseCode() == 201) {
                String response = IpnbConnection.getResponse(httpsConnection);
                OldFormatSessionWrapper wrapper = (OldFormatSessionWrapper)new GsonBuilder().create().fromJson(response, OldFormatSessionWrapper.class);
                return wrapper.kernel.id;
            }
            httpsConnection.disconnect();
        }
        return null;
    }

    private static byte[] createNewFormatKernelPostParameters(@NotNull String pathToFile, @NotNull String kernelName) {
        if (pathToFile == null) {
            IpnbConnection.$$$reportNull$$$0(17);
        }
        if (kernelName == null) {
            IpnbConnection.$$$reportNull$$$0(18);
        }
        SessionWrapper sessionWrapper = new SessionWrapper(kernelName, pathToFile, "notebook");
        return new GsonBuilder().create().toJson((Object)sessionWrapper).getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] createOldFormatKernelPostParameters(@NotNull String pathToFile, @NotNull String kernelName) {
        if (pathToFile == null) {
            IpnbConnection.$$$reportNull$$$0(19);
        }
        if (kernelName == null) {
            IpnbConnection.$$$reportNull$$$0(20);
        }
        OldFormatSessionWrapper sessionWrapper = new OldFormatSessionWrapper(kernelName, pathToFile);
        return new GsonBuilder().create().toJson((Object)sessionWrapper).getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    private String getLoginUrl() throws IOException {
        String location = "";
        String loginUrl = this.myURI.toString() + DEFAULT_LOGIN_PATH;
        if (this.myURI.getScheme().equals("https")) {
            this.configureHttpsConnection();
            HttpsURLConnection connection = (HttpsURLConnection)new URL(loginUrl).openConnection();
            try {
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                if (connection.getResponseCode() == 302) {
                    location = connection.getHeaderField("Location");
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Connection refused: " + e.getMessage());
            }
            finally {
                connection.disconnect();
            }
        }
        String string = location.isEmpty() ? DEFAULT_LOGIN_PATH : location;
        if (string == null) {
            IpnbConnection.$$$reportNull$$$0(21);
        }
        return string;
    }

    private void initXSRF(String url) throws IOException {
        URLConnection connection = null;
        try {
            connection = new URL(url).openConnection();
            connection.getHeaderFields();
            List<HttpCookie> cookies = this.myCookieManager.getCookieStore().getCookies();
            for (HttpCookie cookie : cookies) {
                if (!XSRF_PARAMETER.equals(cookie.getName())) continue;
                this.myXsrf = cookie.getValue();
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    protected void initializeClients() throws URISyntaxException {
        Draft17WithOrigin draft = new Draft17WithOrigin();
        this.myShellClient = new WebSocketClient(this.getShellURI(), (Draft)draft, this.myHeaders, 0){

            public void onOpen(@NotNull ServerHandshake handshakeData) {
                if (handshakeData == null) {
                    2.$$$reportNull$$$0(0);
                }
                Message message = IpnbConnection.this.createMessage("connect_request", UUID.randomUUID().toString(), null, null);
                this.send(new Gson().toJson((Object)message));
                IpnbConnection.this.myIsShellOpen = true;
                IpnbConnection.this.notifyOpen();
            }

            public void onMessage(@NotNull String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void onClose(int code, @NotNull String reason, boolean remote) {
                if (reason == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            public void onError(@NotNull Exception e) {
                if (e == null) {
                    2.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handshakeData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reason";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onOpen";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onMessage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClose";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myShellThread = new Thread((Runnable)this.myShellClient, "IPNB shell client");
        this.myShellThread.start();
        this.myIOPubClient = new IpnbWebSocketClient(this.getIOPubURI(), (Draft)draft);
        this.myIOPubThread = new Thread((Runnable)this.myIOPubClient, "IPNB pub client");
        this.myIOPubThread.start();
    }

    protected void notifyOpen() {
        if (!this.myIsOpened && this.myIsShellOpen && this.myIsIOPubOpen) {
            this.myIsOpened = true;
            this.myListener.onOpen(this);
        }
    }

    public boolean isAlive() {
        return this.myShellClient.isOpen() && this.myIOPubClient.isOpen();
    }

    @NotNull
    public String execute(@NotNull String code) {
        if (code == null) {
            IpnbConnection.$$$reportNull$$$0(22);
        }
        String messageId = UUID.randomUUID().toString();
        this.myShellClient.send(new Gson().toJson((Object)this.createExecuteRequest(code, messageId)));
        String string = messageId;
        if (string == null) {
            IpnbConnection.$$$reportNull$$$0(23);
        }
        return string;
    }

    public void shutdown() {
        this.myIOPubClient.close();
        this.myShellClient.close();
    }

    public void close() throws IOException, InterruptedException {
        this.myIOPubThread.join();
        this.myShellThread.join();
        this.shutdownKernel();
    }

    @NotNull
    public String getKernelId() {
        String string = this.myKernelId;
        if (string == null) {
            IpnbConnection.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private String startKernel() throws IOException {
        String s = this.httpRequest(this.myURI + KERNELS_URL, HTTPMethod.POST.name());
        Gson gson = new Gson();
        Kernel kernel = (Kernel)gson.fromJson(s, Kernel.class);
        String string = kernel.getId();
        if (string == null) {
            IpnbConnection.$$$reportNull$$$0(25);
        }
        return string;
    }

    protected void shutdownKernel() throws IOException {
        if (this.myIsHubServer) {
            this.httpRequest(this.myURI + USER_PATH + "/" + IpnbSettings.getInstance(this.myProject).getUsername() + KERNELS_URL + "/" + this.myKernelId, HTTPMethod.DELETE.name());
        } else {
            this.httpRequest(this.myURI + KERNELS_URL + "/" + this.myKernelId, HTTPMethod.DELETE.name());
        }
    }

    public void interrupt() throws IOException {
        this.httpRequest(this.myURI + KERNELS_URL + "/" + this.myKernelId + "/interrupt", HTTPMethod.POST.name());
    }

    public void reload() throws IOException {
        this.httpRequest(this.myURI + KERNELS_URL + "/" + this.myKernelId + "/restart", HTTPMethod.POST.name());
    }

    @NotNull
    public URI getShellURI() throws URISyntaxException {
        URI uRI = new URI(this.getWebSocketURIBase() + "/shell");
        if (uRI == null) {
            IpnbConnection.$$$reportNull$$$0(26);
        }
        return uRI;
    }

    @NotNull
    public URI getIOPubURI() throws URISyntaxException {
        URI uRI = new URI(this.getWebSocketURIBase() + "/iopub");
        if (uRI == null) {
            IpnbConnection.$$$reportNull$$$0(27);
        }
        return uRI;
    }

    @NotNull
    protected String getWebSocketURIBase() {
        String scheme = this.myURI.getScheme();
        String prefix = scheme.equals("http") ? "ws://" : "wss://";
        String hubPath = this.myIsHubServer ? "/user/" + IpnbSettings.getInstance(this.myProject).getUsername() : "";
        String string = prefix + this.myURI.getAuthority() + hubPath + KERNELS_URL + "/" + this.myKernelId;
        if (string == null) {
            IpnbConnection.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private String httpRequest(@NotNull String url, @NotNull String method) throws IOException {
        URLConnection urlConnection;
        if (url == null) {
            IpnbConnection.$$$reportNull$$$0(29);
        }
        if (method == null) {
            IpnbConnection.$$$reportNull$$$0(30);
        }
        if ((urlConnection = new URL(url).openConnection()) instanceof HttpURLConnection) {
            HttpURLConnection connection = this.configureConnection((HttpURLConnection)urlConnection, method);
            int code = connection.getResponseCode();
            if (code == 403) {
                throw new IOException(AUTHENTICATION_NEEDED);
            }
            String string = IpnbConnection.getResponse(connection);
            if (string == null) {
                IpnbConnection.$$$reportNull$$$0(31);
            }
            return string;
        }
        throw new UnsupportedOperationException("Only HTTP URLs are supported");
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static String getResponse(HttpURLConnection connection) throws IOException {
        int n;
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        Throwable throwable = null;
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, n);
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            IpnbConnection.$$$reportNull$$$0(32);
        }
        return string2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    @NotNull
    private HttpURLConnection configureConnection(HttpURLConnection urlConnection, @NotNull String method) throws ProtocolException {
        if (method == null) {
            IpnbConnection.$$$reportNull$$$0(33);
        }
        urlConnection.setRequestMethod(method);
        urlConnection.setReadTimeout(60000);
        urlConnection.setInstanceFollowRedirects(false);
        if (!StringUtil.isEmptyOrSpaces((String)this.myToken)) {
            urlConnection.setRequestProperty("Authorization", "token " + this.myToken);
        } else if (!StringUtil.isEmptyOrSpaces((String)this.myXsrf)) {
            urlConnection.setRequestProperty(XSRF_TOKEN_HEADER, this.myXsrf);
        }
        if (!this.myHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.myHeaders.entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        HttpURLConnection httpURLConnection = urlConnection;
        if (httpURLConnection == null) {
            IpnbConnection.$$$reportNull$$$0(34);
        }
        return httpURLConnection;
    }

    @NotNull
    public Message createExecuteRequest(String code, String messageId) {
        JsonObject content = new JsonObject();
        content.addProperty("code", code);
        content.addProperty("silent", Boolean.valueOf(false));
        content.add("user_variables", (JsonElement)new JsonArray());
        content.add("output_type", (JsonElement)new JsonPrimitive(""));
        content.add("user_expressions", (JsonElement)new JsonObject());
        content.addProperty("allow_stdin", Boolean.valueOf(false));
        Message message = this.createMessage("execute_request", messageId, content, USERNAME_PARAMETER);
        if (message == null) {
            IpnbConnection.$$$reportNull$$$0(35);
        }
        return message;
    }

    private Message createMessage(@NotNull String messageType, @NotNull String messageId, @Nullable JsonObject content, @Nullable String username) {
        if (messageType == null) {
            IpnbConnection.$$$reportNull$$$0(36);
        }
        if (messageId == null) {
            IpnbConnection.$$$reportNull$$$0(37);
        }
        Header header = Header.create(messageId, username, this.mySessionId, messageType);
        JsonObject parentHeader = new JsonObject();
        JsonObject metadata = new JsonObject();
        return Message.create(header, parentHeader, metadata, content);
    }

    protected void addCellOutput(@NotNull PyContent content) {
        if (content == null) {
            IpnbConnection.$$$reportNull$$$0(38);
        }
        if (content instanceof PyErrContent) {
            this.myOutput = new IpnbErrorOutputCell(((PyErrContent)content).getEvalue(), ((PyErrContent)content).getEname(), ((PyErrContent)content).getTraceback(), null, null);
        } else if (content instanceof PyStreamContent) {
            String data = ((PyStreamContent)content).getData();
            this.myOutput = new IpnbStreamOutputCell(((PyStreamContent)content).getName(), Lists.newArrayList((Object[])new String[]{data}), null, null);
        } else if (content instanceof PyOutContent) {
            Map<String, Object> data = ((PyOutContent)content).getData();
            String plainText = (String)data.get("text/plain");
            if (data.containsKey("text/latex")) {
                String text = (String)data.get("text/latex");
                this.myOutput = new IpnbLatexOutputCell(Lists.newArrayList((Object[])new String[]{text}), false, null, Lists.newArrayList((Object[])new String[]{plainText}), null);
            } else if (data.containsKey("text/markdown")) {
                String text = (String)data.get("text/markdown");
                this.myOutput = new IpnbLatexOutputCell(Lists.newArrayList((Object[])new String[]{text}), true, null, Lists.newArrayList((Object[])new String[]{plainText}), null);
            } else if (data.containsKey("text/html")) {
                String html = (String)data.get("text/html");
                this.myOutput = new IpnbHtmlOutputCell(Lists.newArrayList((Object[])StringUtil.splitByLinesKeepSeparators((String)html)), Lists.newArrayList((Object[])StringUtil.splitByLinesKeepSeparators((String)html)), ((PyOutContent)content).getExecutionCount(), null);
            } else if (data.containsKey("image/png")) {
                String png = (String)data.get("image/png");
                this.myOutput = new IpnbPngOutputCell(png, Lists.newArrayList((Object[])StringUtil.splitByLinesKeepSeparators((String)plainText)), null, null);
            } else if (data.containsKey("image/jpeg")) {
                String jpeg = (String)data.get("image/jpeg");
                this.myOutput = new IpnbJpegOutputCell(jpeg, Lists.newArrayList((Object[])StringUtil.splitByLinesKeepSeparators((String)plainText)), null, null);
            } else if (data.containsKey("image/svg")) {
                String svg = (String)data.get("image/svg");
                this.myOutput = new IpnbSvgOutputCell(Lists.newArrayList((Object[])StringUtil.splitByLinesKeepSeparators((String)svg)), Lists.newArrayList((Object[])StringUtil.splitByLinesKeepSeparators((String)plainText)), null, null);
            } else if (plainText != null) {
                this.myOutput = new IpnbOutOutputCell(Lists.newArrayList((Object[])new String[]{plainText}), ((PyOutContent)content).getExecutionCount(), null);
            }
        }
    }

    public IpnbOutputCell getOutput() {
        return this.myOutput;
    }

    public int getExecCount() {
        return this.myExecCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFile";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loginUrl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = USERNAME_PARAMETER;
                break;
            }
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redirectUrl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = PASSWORD_PARAMETER;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnection";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kernelName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageId";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createApiUrl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoginUrl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKernelId";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "startKernel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellURI";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getIOPubURI";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebSocketURIBase";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "httpRequest";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponse";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "configureConnection";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecuteRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "authorizeAndGetKernel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startJupyterNotebookServer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isHubServer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "login";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createApiUrl";
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExistingKernelForSession";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewFormatKernelPostParameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createOldFormatKernelPostParameters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "httpRequest";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "configureConnection";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addCellOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NotebookWrapper {
        String path;

        NotebookWrapper(String path) {
            this.path = path;
        }
    }

    private static class KernelWrapper {
        String id;
        String name;

        KernelWrapper(String name) {
            this.name = name;
        }
    }

    private static class OldFormatSessionWrapper {
        NotebookWrapper notebook;
        KernelWrapper kernel;

        OldFormatSessionWrapper(String interpreterName, String filePath) {
            this.kernel = new KernelWrapper(interpreterName);
            this.notebook = new NotebookWrapper(filePath);
        }
    }

    private static class SessionWrapper {
        KernelWrapper kernel;
        String name;
        String path;
        String type = "notebook";

        SessionWrapper(String kernelName, String path, String type) {
            this.kernel = new KernelWrapper(kernelName);
            this.name = "";
            this.path = path;
            this.type = type;
        }
    }

    protected class IpnbWebSocketClient
    extends WebSocketClient {
        protected IpnbWebSocketClient(@NotNull URI serverUri, Draft draft) {
            if (serverUri == null) {
                IpnbWebSocketClient.$$$reportNull$$$0(0);
            }
            if (draft == null) {
                IpnbWebSocketClient.$$$reportNull$$$0(1);
            }
            super(serverUri, draft, (Map)IpnbConnection.this.myHeaders, 10000);
            this.configureSsl(serverUri);
        }

        private void configureSsl(@NotNull URI serverUri) {
            if (serverUri == null) {
                IpnbWebSocketClient.$$$reportNull$$$0(2);
            }
            if (serverUri.getScheme().equals("wss")) {
                SSLContext sslContext = CertificateManager.getInstance().getSslContext();
                try {
                    this.setSocket(sslContext.getSocketFactory().createSocket());
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                }
            }
        }

        public void onOpen(ServerHandshake handshakeData) {
            Message message = IpnbConnection.this.createMessage("connect_request", UUID.randomUUID().toString(), null, null);
            this.send(new Gson().toJson((Object)message));
            IpnbConnection.this.myIsIOPubOpen = true;
            IpnbConnection.this.notifyOpen();
        }

        public void onMessage(String message) {
            PyContent content;
            Gson gson = new Gson();
            Message msg = (Message)gson.fromJson(message, Message.class);
            Header header = msg.getHeader();
            Header parentHeader = (Header)gson.fromJson((JsonElement)msg.getParentHeader(), Header.class);
            String messageType = header.getMessageType();
            if ("pyout".equals(messageType) || "display_data".equals(messageType) || "execute_result".equals(messageType)) {
                content = (PyOutContent)gson.fromJson((JsonElement)msg.getContent(), PyOutContent.class);
                IpnbConnection.this.addCellOutput(content);
                IpnbConnection.this.myListener.onOutput(IpnbConnection.this, parentHeader.getMessageId());
            }
            if ("execute_reply".equals(messageType)) {
                content = (PyExecuteReplyContent)gson.fromJson((JsonElement)msg.getContent(), PyExecuteReplyContent.class);
                List payloads = ((PyExecuteReplyContent)content).payload;
                if (payloads != null && !payloads.isEmpty()) {
                    Payload payload = (Payload)payloads.get(0);
                    if (payload.replace) {
                        IpnbConnection.this.myListener.onPayload(payload.text, parentHeader.getMessageId());
                    }
                }
                if ("ok".equals(((PyExecuteReplyContent)content).status) || "error".equals(((PyExecuteReplyContent)content).status)) {
                    IpnbConnection.this.myListener.onFinished(IpnbConnection.this, parentHeader.getMessageId());
                }
            } else if ("pyerr".equals(messageType) || "error".equals(messageType)) {
                content = (PyErrContent)gson.fromJson((JsonElement)msg.getContent(), PyErrContent.class);
                IpnbConnection.this.addCellOutput(content);
                IpnbConnection.this.myListener.onOutput(IpnbConnection.this, parentHeader.getMessageId());
            } else if ("stream".equals(messageType)) {
                content = (PyStreamContent)gson.fromJson((JsonElement)msg.getContent(), PyStreamContent.class);
                IpnbConnection.this.addCellOutput(content);
                IpnbConnection.this.myListener.onOutput(IpnbConnection.this, parentHeader.getMessageId());
            } else if ("pyin".equals(messageType) || "execute_input".equals(messageType)) {
                JsonElement executionCount = msg.getContent().get("execution_count");
                if (executionCount != null) {
                    IpnbConnection.this.myExecCount = executionCount.getAsInt();
                }
                IpnbConnection.this.myOutput = null;
                IpnbConnection.this.myListener.onOutput(IpnbConnection.this, parentHeader.getMessageId());
            }
        }

        public void onClose(int code, String reason, boolean remote) {
            LOG.info("IPNB WebSocket was closed:  code " + code + " reason: " + reason);
        }

        public void onError(Exception ex) {
            LOG.error((Throwable)ex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverUri";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "draft";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$IpnbWebSocketClient";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureSsl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class Draft17WithOrigin
    extends Draft_17 {
        protected Draft17WithOrigin() {
        }

        public Draft copyInstance() {
            return new Draft17WithOrigin();
        }

        @NotNull
        public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(@NotNull ClientHandshakeBuilder request) {
            if (request == null) {
                Draft17WithOrigin.$$$reportNull$$$0(0);
            }
            super.postProcessHandshakeRequestAsClient(request);
            request.put("Origin", IpnbConnection.this.myURI.toString());
            ClientHandshakeBuilder clientHandshakeBuilder = request;
            if (clientHandshakeBuilder == null) {
                Draft17WithOrigin.$$$reportNull$$$0(1);
            }
            return clientHandshakeBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Draft17WithOrigin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Draft17WithOrigin";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "postProcessHandshakeRequestAsClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "postProcessHandshakeRequestAsClient";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class PyStatusContent {
        private String execution_state;

        protected PyStatusContent() {
        }

        public String getExecutionState() {
            return this.execution_state;
        }
    }

    protected static class PyStreamContent
    implements PyContent {
        private String text;
        private String data;
        private String name;

        protected PyStreamContent() {
        }

        public String getData() {
            return this.data == null ? this.text : this.data;
        }

        public String getName() {
            return this.name;
        }
    }

    protected static class PyErrContent
    implements PyContent {
        private String ename;
        private String evalue;
        private List<String> traceback;

        protected PyErrContent() {
        }

        public String getEname() {
            return this.ename;
        }

        public String getEvalue() {
            return this.evalue;
        }

        public List<String> getTraceback() {
            return this.traceback;
        }
    }

    protected static class PyOutContent
    implements PyContent {
        private int execution_count;
        private HashMap<String, Object> data;
        private JsonObject metadata;

        protected PyOutContent() {
        }

        public int getExecutionCount() {
            return this.execution_count;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public JsonObject getMetadata() {
            return this.metadata;
        }
    }

    protected static class PyExecuteReplyContent
    implements PyContent {
        private int execution_count;
        private JsonObject metadata;
        private String status;
        private List<Payload> payload;

        protected PyExecuteReplyContent() {
        }

        public int getExecutionCount() {
            return this.execution_count;
        }

        public JsonObject getMetadata() {
            return this.metadata;
        }

        public List<Payload> getPayload() {
            return this.payload;
        }
    }

    protected static class Payload {
        String text;
        boolean replace;
        String source;

        protected Payload() {
        }
    }

    private static interface PyContent {
    }

    protected static class Message {
        private Header header;
        private JsonObject parent_header;
        private JsonObject metadata;
        private JsonObject content;
        private JsonPrimitive channel;

        protected Message() {
        }

        public static Message create(Header header, JsonObject parentHeader, JsonObject metadata, JsonObject content) {
            Message message = new Message();
            message.header = header;
            message.parent_header = parentHeader;
            message.metadata = metadata;
            message.content = content;
            message.channel = new JsonPrimitive("shell");
            return message;
        }

        public Header getHeader() {
            return this.header;
        }

        public JsonObject getParentHeader() {
            return this.parent_header;
        }

        public JsonObject getMetadata() {
            return this.metadata;
        }

        public JsonObject getContent() {
            return this.content;
        }
    }

    protected static class Header {
        private String msg_id;
        private String username;
        private String session;
        private String msg_type;

        protected Header() {
        }

        @NotNull
        public static Header create(String messageId, String username, String sessionId, String messageType) {
            Header header = new Header();
            header.msg_id = messageId;
            header.username = username;
            header.session = sessionId;
            header.msg_type = messageType;
            Header header2 = header;
            if (header2 == null) {
                Header.$$$reportNull$$$0(0);
            }
            return header2;
        }

        public String getMessageId() {
            return this.msg_id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getSessionId() {
            return this.session;
        }

        public String getMessageType() {
            return this.msg_type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Header", "create"));
        }
    }

    private static class Kernel {
        @NotNull
        private String id;

        private Kernel() {
        }

        @NotNull
        public String getId() {
            String string = this.id;
            if (string == null) {
                Kernel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Kernel", "getId"));
        }
    }
}

