/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;

public abstract class ResourceException
extends IOException {
    public ResourceException() {
    }

    public ResourceException(Throwable t) {
        super(t);
    }

    public abstract RaiseException newRaiseException(Ruby var1);

    @Deprecated
    public static class IOError
    extends ResourceException {
        private final IOException ioe;

        IOError(IOException ioe) {
            super(ioe);
            this.ioe = ioe;
        }

        @Override
        public RaiseException newRaiseException(Ruby runtime2) {
            return runtime2.newIOErrorFromException(this.ioe);
        }
    }

    public static class TooManySymlinks
    extends ErrnoException {
        public TooManySymlinks(String path2) {
            super("ELOOP", path2);
        }
    }

    public static class InvalidArguments
    extends ErrnoException {
        public InvalidArguments(String path2) {
            super("EINVAL", path2);
        }
    }

    public static class PermissionDenied
    extends ErrnoException {
        public PermissionDenied(String path2) {
            super("EACCES", path2);
        }
    }

    public static class NotFound
    extends ErrnoException {
        public NotFound(String path2) {
            super("ENOENT", path2);
        }
    }

    public static class FileExists
    extends ErrnoException {
        public FileExists(String path2) {
            super("EEXIST", path2);
        }
    }

    public static class FileIsNotDirectory
    extends ErrnoException {
        public FileIsNotDirectory(String path2) {
            super("ENOTDIR", path2);
        }
    }

    public static class FileIsDirectory
    extends ErrnoException {
        public FileIsDirectory(String path2) {
            super("EISDIR", path2);
        }
    }

    static abstract class ErrnoException
    extends ResourceException {
        private final String path;
        private final String errnoClass;

        protected ErrnoException(String errnoClass, String path2) {
            this.errnoClass = errnoClass;
            this.path = path2;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public RaiseException newRaiseException(Ruby runtime2) {
            return runtime2.newRaiseException(runtime2.getErrno().getClass(this.errnoClass), this.path);
        }
    }
}

