/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.CoroutinePosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.LambdaArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StubType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "analyzeLambda", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "diagnosticHolder", "Context", "resolution"})
public final class PostponedArgumentsAnalyzer {
    private final CallableReferenceResolver callableReferenceResolver;

    public final void analyze(@NotNull Context c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedAtom argument, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(resolutionCallbacks, "resolutionCallbacks");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(diagnosticsHolder, "diagnosticsHolder");
        ResolvedAtom resolvedAtom = argument;
        if (resolvedAtom instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, resolutionCallbacks, (ResolvedLambdaAtom)argument, diagnosticsHolder);
        } else if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            this.analyzeLambda(c, resolutionCallbacks, PostponeArgumentsChecksKt.transformToResolvedLambda((LambdaWithTypeVariableAsExpectedTypeAtom)argument, c.getBuilder()), diagnosticsHolder);
        } else if (resolvedAtom instanceof ResolvedCallableReferenceAtom) {
            this.callableReferenceResolver.processCallableReferenceArgument(c.getBuilder(), (ResolvedCallableReferenceAtom)argument, diagnosticsHolder);
        } else {
            if (resolvedAtom instanceof ResolvedCollectionLiteralAtom) {
                String string = "Not supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            String string = "Unexpected resolved primitive: " + argument.getClass().getCanonicalName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeLambda(Context c, KotlinResolutionCallbacks resolutionCallbacks, ResolvedLambdaAtom lambda2, KotlinDiagnosticsHolder diagnosticHolder) {
        Object object;
        void $this$mapTo$iv$iv;
        void returnArguments;
        List<KotlinCallArgument> $this$mapTo$iv$iv2;
        UnwrappedType unwrappedType;
        Object p1;
        Object object2;
        UnwrappedType $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<NewTypeVariable, StubType> stubsForPostponedVariables;
        Map<NewTypeVariable, StubType> map2 = stubsForPostponedVariables = c.bindingStubsForPostponedVariables();
        Object object3 = c;
        boolean $i$f$mapKeys = false;
        void var9_10 = $this$mapKeys$iv;
        Map destination$iv$iv22 = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv22;
            boolean bl = false;
            TypeConstructor typeConstructor2 = ((NewTypeVariable)entry.getKey()).getFreshTypeConstructor();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TypeConstructor typeConstructor3 = typeConstructor2;
            Object object4 = object2;
            boolean bl2 = false;
            Object entry3 = it$iv$iv.getValue();
            object4.put(typeConstructor3, entry3);
        }
        object2 = destination$iv$iv22;
        NewTypeSubstitutor currentSubstitutor2 = object3.buildCurrentSubstitutor((Map<TypeConstructor, StubType>)object2);
        Function1<UnwrappedType, UnwrappedType> $fun$substitute$1 = new Function1<UnwrappedType, UnwrappedType>(currentSubstitutor2){
            final /* synthetic */ NewTypeSubstitutor $currentSubstitutor;

            @NotNull
            public final UnwrappedType invoke(@NotNull UnwrappedType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return this.$currentSubstitutor.safeSubstitute(type2);
            }
            {
                this.$currentSubstitutor = newTypeSubstitutor;
                super(1);
            }
        };
        UnwrappedType unwrappedType2 = lambda2.getReceiver();
        if (unwrappedType2 != null) {
            $this$mapKeysTo$iv$iv = unwrappedType2;
            boolean destination$iv$iv22 = false;
            $i$f$mapKeysTo = false;
            p1 = $this$mapKeysTo$iv$iv;
            boolean bl = false;
            unwrappedType = $fun$substitute$1.invoke((UnwrappedType)p1);
        } else {
            unwrappedType = null;
        }
        UnwrappedType receiver2 = unwrappedType;
        Iterable $this$map$iv = lambda2.getParameters();
        boolean $i$f$map = false;
        p1 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo232 = false;
        for (Object e : $this$mapTo$iv$iv2) {
            void p12;
            UnwrappedType bl = (UnwrappedType)e;
            object3 = destination$iv$iv3;
            boolean bl3 = false;
            object2 = $fun$substitute$1.invoke((UnwrappedType)p12);
            object3.add(object2);
        }
        List parameters2 = (List)destination$iv$iv3;
        UnwrappedType rawReturnType = lambda2.getReturnType();
        UnwrappedType expectedTypeForReturnArguments = c.canBeProper(rawReturnType) ? $fun$substitute$1.invoke(rawReturnType) : (c.hasUpperOrEqualUnitConstraint(rawReturnType) ? (UnwrappedType)TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType() : null);
        Pair<List<KotlinCallArgument>, InferenceSession> $i$f$mapTo232 = resolutionCallbacks.analyzeAndGetLambdaReturnArguments(lambda2.getAtom(), lambda2.isSuspend(), receiver2, parameters2, expectedTypeForReturnArguments, stubsForPostponedVariables);
        $this$mapTo$iv$iv2 = $i$f$mapTo232.component1();
        InferenceSession inferenceSession = $i$f$mapTo232.component2();
        Iterable $this$forEach$iv = (Iterable)returnArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallArgument it = (KotlinCallArgument)element$iv;
            boolean bl = false;
            ConstraintSystemBuilderKt.addSubsystemFromArgument(c, it);
        }
        Iterable $this$map$iv2 = (Iterable)returnArguments;
        boolean bl = false;
        Iterable element$iv = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinCallArgument kotlinCallArgument = (KotlinCallArgument)item$iv$iv;
            object3 = destination$iv$iv4;
            boolean bl2 = false;
            UnwrappedType unwrappedType3 = lambda2.getReturnType();
            void var25_62 = it;
            ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            UnwrappedType p13 = unwrappedType3;
            boolean bl6 = false;
            UnwrappedType unwrappedType4 = $fun$substitute$1.invoke(p13);
            object2 = PostponeArgumentsChecksKt.resolveKtPrimitive(constraintSystemBuilder, (KotlinCallArgument)var25_62, unwrappedType4, diagnosticHolder, false);
            object3.add(object2);
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv4;
        if (returnArguments.isEmpty()) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "lambda.returnType.builtIns.unitType");
            SimpleType unitType = simpleType2;
            object = lambda2.getReturnType();
            boolean bl5 = false;
            $i$f$mapTo32 = false;
            UnwrappedType p14 = object;
            boolean bl7 = false;
            UnwrappedType unwrappedType5 = $fun$substitute$1.invoke(p14);
            c.getBuilder().addSubtypeConstraint(unwrappedType5, unitType, new LambdaArgumentConstraintPosition(lambda2));
            c.getBuilder().addSubtypeConstraint(unitType, unwrappedType5, new LambdaArgumentConstraintPosition(lambda2));
        }
        lambda2.setAnalyzedResults((List<? extends KotlinCallArgument>)returnArguments, subResolvedKtPrimitives);
        if (inferenceSession != null) {
            Map<TypeConstructor, UnwrappedType> map3;
            ConstraintStorage storageSnapshot = c.getBuilder().currentStorage();
            Map<TypeConstructor, UnwrappedType> $i$f$mapTo32 = map3 = inferenceSession.inferPostponedVariables(lambda2, storageSnapshot);
            boolean p14 = false;
            Iterator<Map.Entry<TypeConstructor, UnwrappedType>> iterator2 = $i$f$mapTo32.entrySet().iterator();
            while (iterator2.hasNext()) {
                VariableWithConstraints variableWithConstraints;
                Object bl7 = object = iterator2.next();
                boolean it = false;
                TypeConstructor constructor = (TypeConstructor)bl7.getKey();
                bl7 = object;
                it = false;
                UnwrappedType resultType = (UnwrappedType)bl7.getValue();
                if (storageSnapshot.getNotFixedTypeVariables().get(constructor) == null) {
                    continue;
                }
                NewTypeVariable variable2 = variableWithConstraints.getTypeVariable();
                c.getBuilder().unmarkPostponedVariable(variable2);
                c.getBuilder().addEqualityConstraint(variable2.getDefaultType(), resultType, new CoroutinePosition());
            }
        }
    }

    public PostponedArgumentsAnalyzer(@NotNull CallableReferenceResolver callableReferenceResolver) {
        Intrinsics.checkParameterIsNotNull(callableReferenceResolver, "callableReferenceResolver");
        this.callableReferenceResolver = callableReferenceResolver;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H&J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0007H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "", "addOtherSystem", "", "otherSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "bindingStubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewTypeVariable;", "Lorg/jetbrains/kotlin/types/StubType;", "buildCurrentSubstitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "additionalBindings", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "canBeProper", "", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "getBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "hasUpperOrEqualUnitConstraint", "resolution"})
    public static interface Context {
        @NotNull
        public NewTypeSubstitutor buildCurrentSubstitutor(@NotNull Map<TypeConstructor, StubType> var1);

        @NotNull
        public Map<NewTypeVariable, StubType> bindingStubsForPostponedVariables();

        public boolean canBeProper(@NotNull UnwrappedType var1);

        public boolean hasUpperOrEqualUnitConstraint(@NotNull UnwrappedType var1);

        public void addOtherSystem(@NotNull ConstraintStorage var1);

        @NotNull
        public ConstraintSystemBuilder getBuilder();
    }
}

