/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jsampler.CC;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.LSConsolePane;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ViewConfig;
import org.jsampler.view.std.JSLscpScriptDlg;
import org.jsampler.view.std.StdUtils;

public class LSConsoleFrame
extends JFrame {
    private final JMenuBar menuBar = new JMenuBar();
    private final LSConsolePane lsConsolePane = new LSConsolePane(this);

    public LSConsoleFrame() {
        this.setTitle(FantasiaI18n.i18n.getLabel("LSConsoleFrame.title"));
        if (Res.iconAppIcon != null) {
            this.setIconImage(Res.iconLSConsole.getImage());
        }
        this.add(this.lsConsolePane);
        this.addMenu();
        this.pack();
        this.setSavedSize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LSConsoleFrame.this.onWindowClose();
            }
        });
    }

    private void addMenu() {
        if (CC.getViewConfig().isUsingScreenMenuBar()) {
            ((ViewConfig)CC.getViewConfig()).setNativeMenuProperties();
        }
        this.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(FantasiaI18n.i18n.getMenuLabel("lsconsole.actions"));
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        this.menuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(FantasiaI18n.i18n.getMenuLabel("lsconsole.clear"));
        JMenuItem jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("lsconsole.clearConsole"));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this.lsConsolePane.clearConsoleAction);
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("lsconsole.clearSessionHistory"));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this.lsConsolePane.clearSessionHistoryAction);
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu(FantasiaI18n.i18n.getMenuLabel("lsconsole.export"));
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("lsconsole.export.session"));
        jMenu3.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSLscpScriptDlg jSLscpScriptDlg = new JSLscpScriptDlg();
                jSLscpScriptDlg.setCommands(LSConsoleFrame.this.lsConsolePane.getModel().getSessionHistory());
                jSLscpScriptDlg.setVisible(true);
            }
        });
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("lsconsole.export.commandHistory"));
        jMenu3.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSLscpScriptDlg jSLscpScriptDlg = new JSLscpScriptDlg();
                jSLscpScriptDlg.setCommands(LSConsoleFrame.this.lsConsolePane.getModel().getCommandHistory());
                jSLscpScriptDlg.setVisible(true);
            }
        });
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("lsconsole.runScript"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((MainFrame)CC.getMainFrame()).runScript();
            }
        });
        if (CC.getViewConfig().isUsingScreenMenuBar()) {
            ((ViewConfig)CC.getViewConfig()).restoreMenuProperties();
        }
    }

    private void onWindowClose() {
        boolean bl = (this.getExtendedState() & 6) == 6;
        FantasiaPrefs.preferences().setBoolProperty("LSConsoleFrame.windowMaximized", bl);
        if (bl) {
            return;
        }
        StdUtils.saveWindowBounds("LSConsoleFrame", this.getBounds());
    }

    private void setDefaultSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        this.setBounds(100, 100, (int)d - 200, (int)d2 - 200);
    }

    private void setSavedSize() {
        Rectangle rectangle = StdUtils.getWindowBounds("LSConsoleFrame");
        if (rectangle == null) {
            this.setDefaultSize();
            return;
        }
        this.setBounds(rectangle);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        super.setVisible(bl);
        if (bl && FantasiaPrefs.preferences().getBoolProperty("LSConsoleFrame.windowMaximized")) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    protected LSConsolePane getLSConsolePane() {
        return this.lsConsolePane;
    }
}

