/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class HelpTOCLoader {
    private Map<String, DefaultMutableTreeNode> nodes;
    private String baseURL;

    public HelpTOCLoader(Map<String, DefaultMutableTreeNode> map, String string) {
        this.nodes = map;
        this.baseURL = string;
    }

    public DefaultMutableTreeNode createTOC() {
        EditPlugin[] editPluginArray = jEdit.getPlugins();
        Arrays.sort(editPluginArray, new PluginCompare());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.add(this.createNode("welcome.html", jEdit.getProperty("helpviewer.toc.welcome")));
        defaultMutableTreeNode.add(this.createNode("README.txt", jEdit.getProperty("helpviewer.toc.readme")));
        defaultMutableTreeNode.add(this.createNode("CHANGES.txt", jEdit.getProperty("helpviewer.toc.changes")));
        defaultMutableTreeNode.add(this.createNode("TODO.txt", jEdit.getProperty("helpviewer.toc.todo")));
        defaultMutableTreeNode.add(this.createNode("COPYING.txt", jEdit.getProperty("helpviewer.toc.copying")));
        defaultMutableTreeNode.add(this.createNode("COPYING.DOC.txt", jEdit.getProperty("helpviewer.toc.copying-doc")));
        defaultMutableTreeNode.add(this.createNode("Apache.LICENSE.txt", jEdit.getProperty("helpviewer.toc.copying-apache")));
        defaultMutableTreeNode.add(this.createNode("COPYING.PLUGINS.txt", jEdit.getProperty("helpviewer.toc.copying-plugins")));
        this.loadTOC(defaultMutableTreeNode, "whatsnew/toc.xml");
        this.loadTOC(defaultMutableTreeNode, "users-guide/toc.xml");
        this.loadTOC(defaultMutableTreeNode, "FAQ/toc.xml");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.plugins"), true);
        for (EditPlugin editPlugin : editPluginArray) {
            String string = editPlugin.getClassName();
            String string2 = jEdit.getProperty("plugin." + string + ".docs");
            String string3 = jEdit.getProperty("plugin." + string + ".name");
            if (string3 == null || string2 == null) continue;
            String string4 = editPlugin.getPluginJAR().getClassLoader().getResourceAsPath(string2);
            defaultMutableTreeNode2.add(this.createNode(string4, string3));
        }
        if (defaultMutableTreeNode2.getChildCount() != 0) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.loadTOC(defaultMutableTreeNode, "api/toc.xml");
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new HelpNode(string, string2), true);
        if (this.nodes != null) {
            this.nodes.put(string, defaultMutableTreeNode);
        }
        return defaultMutableTreeNode;
    }

    private void loadTOC(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        TOCHandler tOCHandler = new TOCHandler(defaultMutableTreeNode, MiscUtilities.getParentOfPath(string));
        try {
            XMLUtilities.parseXML(new URL(this.baseURL + '/' + string).openStream(), tOCHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if ("api/toc.xml".equals(string)) {
                Log.log(5, this, "The API docs for jEdit will not be available (reinstall jEdit if you want them)");
                defaultMutableTreeNode.add(this.createNode("http://www.jedit.org/api/overview-summary.html", jEdit.getProperty("helpviewer.toc.online-apidocs")));
            } else {
                Log.log(9, this, fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
        }
    }

    static class PluginCompare
    implements Comparator<EditPlugin> {
        PluginCompare() {
        }

        @Override
        public int compare(EditPlugin editPlugin, EditPlugin editPlugin2) {
            return StandardUtilities.compareStrings(jEdit.getProperty("plugin." + editPlugin.getClassName() + ".name"), jEdit.getProperty("plugin." + editPlugin2.getClassName() + ".name"), true);
        }
    }

    class TOCHandler
    extends DefaultHandler {
        String dir;
        private String tag;
        private StringBuilder title = new StringBuilder();
        private String href;
        private DefaultMutableTreeNode node;
        private Stack<DefaultMutableTreeNode> nodes = new Stack();

        TOCHandler(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
            this.node = defaultMutableTreeNode;
            this.dir = string;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.tag.equals("TITLE")) {
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    char c = cArray[n + i];
                    if (!bl && Character.isWhitespace(c)) continue;
                    bl = true;
                    this.title.append(c);
                }
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.tag = string3;
            if (string3.equals("ENTRY")) {
                this.href = attributes.getValue("HREF");
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3 == null) {
                return;
            }
            if (string3.equals("TITLE")) {
                DefaultMutableTreeNode defaultMutableTreeNode = HelpTOCLoader.this.createNode(this.dir + this.href, this.title.toString());
                this.node.add(defaultMutableTreeNode);
                this.nodes.push(this.node);
                this.node = defaultMutableTreeNode;
                this.title.setLength(0);
            } else if (string3.equals("ENTRY")) {
                this.node = this.nodes.pop();
                this.href = null;
            }
        }
    }

    public static class HelpNode {
        public final String href;
        public final String title;

        HelpNode(String string, String string2) {
            this.href = string;
            this.title = string2;
        }

        public String toString() {
            return this.title;
        }
    }
}

