#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.4.1
id: tamarin-prover-theory-1.4.1-IIdBct42f8E7X0Xbqbl4wb
key: tamarin-prover-theory-1.4.1-IIdBct42f8E7X0Xbqbl4wb
license: LicenseRef-GPL
copyright: Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018
maintainer: Simon Meier <simon.meier@inf.ethz.ch>,
            Jannik Dreier <research@jannikdreier.net>,
            Ralf Sasse <ralf.sasse@gmail.com>
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>,
        Jannik Dreier <research@jannikdreier.net>,
        Ralf Sasse <ralf.sasse@gmail.com>
homepage: https://tamarin-prover.github.io/
synopsis: Security protocol types and constraint solver library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
abi: b4605798ecf833172d70327a7e0ed1a5
exposed: True
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.Heuristics
    Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.Guarded
    Theory.Constraint.System.JSON Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Rule
    Theory.Model.Signature Theory.Proof Theory.Text.Parser
    Theory.Text.Parser.Token Theory.Text.Pretty
    Theory.Tools.AbstractInterpretation Theory.Tools.EquationStore
    Theory.Tools.InjectiveFactInstances Theory.Tools.IntruderRules
    Theory.Tools.LoopBreakers Theory.Tools.RuleVariants
    Theory.Tools.Wellformedness
import-dirs: /usr/lib/ghc-8.6.5/site-local/tamarin-prover-theory-1.4.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/tamarin-prover-theory-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/tamarin-prover-theory-1.4.1
hs-libraries: HStamarin-prover-theory-1.4.1-IIdBct42f8E7X0Xbqbl4wb
depends:
    aeson-1.4.3.0-1l3nsKlFRrWAit5U2tQl5L
    aeson-pretty-0.8.7-1spRLiGt1N3KOFMKEkPeQw base-4.12.0.0
    binary-0.8.6.0 bytestring-0.10.8.2 containers-0.6.0.1
    deepseq-1.4.4.0 dlist-0.8.0.6-CQRMCGRgL5B3ZxhntX4iOr
    fclabels-2.0.3.3-4pyYMRW7ZpR7Wol7ycOt3l mtl-2.2.2
    parallel-3.2.2.0-EGl5SOk48TWHAD161C93aQ parsec-3.1.13.0
    process-1.6.5.0 safe-0.3.17-43oyx4B630gDZMbTh3Ttji
    tamarin-prover-term-1.4.1-JGcRzdF3FGA5a1Soy9VSFp
    tamarin-prover-utils-1.4.1-AhIVbtAfS7gEepTUSKZin3 text-1.2.3.1
    transformers-0.5.6.2 uniplate-1.6.12-3hfn8715UWIA9TheyuouGe
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

