/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.util.Strings;

public class ArmoredOutputStream
extends OutputStream {
    public static final String VERSION_HDR = "Version";
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    OutputStream out;
    int[] buf = new int[3];
    int bufPtr = 0;
    CRC24 crc = new CRC24();
    int chunkCount = 0;
    int lastb;
    boolean start = true;
    boolean clearText = false;
    boolean newLine = false;
    String nl = Strings.lineSeparator();
    String type;
    String headerStart = "-----BEGIN PGP ";
    String headerTail = "-----";
    String footerStart = "-----END PGP ";
    String footerTail = "-----";
    String version = "BCPG v1.60";
    Hashtable headers = new Hashtable();

    private void encode(OutputStream outputStream, int[] nArray, int n) throws IOException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int n2 = nArray[0];
                outputStream.write(encodingTable[n2 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[n2 << 4 & 0x3F]);
                outputStream.write(61);
                outputStream.write(61);
                break;
            }
            case 2: {
                int n3 = nArray[0];
                int n4 = nArray[1];
                outputStream.write(encodingTable[n3 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[(n3 << 4 | n4 >>> 4) & 0x3F]);
                outputStream.write(encodingTable[n4 << 2 & 0x3F]);
                outputStream.write(61);
                break;
            }
            case 3: {
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = nArray[2];
                outputStream.write(encodingTable[n5 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[(n5 << 4 | n6 >>> 4) & 0x3F]);
                outputStream.write(encodingTable[(n6 << 2 | n7 >>> 6) & 0x3F]);
                outputStream.write(encodingTable[n7 & 0x3F]);
                break;
            }
            default: {
                throw new IOException("unknown length in encode");
            }
        }
    }

    public ArmoredOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        if (this.nl == null) {
            this.nl = "\r\n";
        }
        this.headers.put(VERSION_HDR, this.version);
    }

    public ArmoredOutputStream(OutputStream outputStream, Hashtable hashtable) {
        this(outputStream);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.headers.put(k, hashtable.get(k));
        }
    }

    public void setHeader(String string, String string2) {
        if (string2 == null) {
            this.headers.remove(string);
        } else {
            this.headers.put(string, string2);
        }
    }

    public void resetHeaders() {
        String string = (String)this.headers.get(VERSION_HDR);
        this.headers.clear();
        if (string != null) {
            this.headers.put(VERSION_HDR, string);
        }
    }

    public void beginClearText(int n) throws IOException {
        int n2;
        String string;
        switch (n) {
            case 2: {
                string = "SHA1";
                break;
            }
            case 8: {
                string = "SHA256";
                break;
            }
            case 9: {
                string = "SHA384";
                break;
            }
            case 10: {
                string = "SHA512";
                break;
            }
            case 5: {
                string = "MD2";
                break;
            }
            case 1: {
                string = "MD5";
                break;
            }
            case 3: {
                string = "RIPEMD160";
                break;
            }
            default: {
                throw new IOException("unknown hash algorithm tag in beginClearText: " + n);
            }
        }
        String string2 = "-----BEGIN PGP SIGNED MESSAGE-----" + this.nl;
        String string3 = "Hash: " + string + this.nl + this.nl;
        for (n2 = 0; n2 != string2.length(); ++n2) {
            this.out.write(string2.charAt(n2));
        }
        for (n2 = 0; n2 != string3.length(); ++n2) {
            this.out.write(string3.charAt(n2));
        }
        this.clearText = true;
        this.newLine = true;
        this.lastb = 0;
    }

    public void endClearText() {
        this.clearText = false;
    }

    private void writeHeaderEntry(String string, String string2) throws IOException {
        int n;
        for (n = 0; n != string.length(); ++n) {
            this.out.write(string.charAt(n));
        }
        this.out.write(58);
        this.out.write(32);
        for (n = 0; n != string2.length(); ++n) {
            this.out.write(string2.charAt(n));
        }
        for (n = 0; n != this.nl.length(); ++n) {
            this.out.write(this.nl.charAt(n));
        }
    }

    public void write(int n) throws IOException {
        int n2;
        if (this.clearText) {
            this.out.write(n);
            if (this.newLine) {
                if (n != 10 || this.lastb != 13) {
                    this.newLine = false;
                }
                if (n == 45) {
                    this.out.write(32);
                    this.out.write(45);
                }
            }
            if (n == 13 || n == 10 && this.lastb != 13) {
                this.newLine = true;
            }
            this.lastb = n;
            return;
        }
        if (this.start) {
            int n3;
            n2 = (n & 0x40) != 0 ? 1 : 0;
            int n4 = 0;
            n4 = n2 != 0 ? n & 0x3F : (n & 0x3F) >> 2;
            switch (n4) {
                case 6: {
                    this.type = "PUBLIC KEY BLOCK";
                    break;
                }
                case 5: {
                    this.type = "PRIVATE KEY BLOCK";
                    break;
                }
                case 2: {
                    this.type = "SIGNATURE";
                    break;
                }
                default: {
                    this.type = "MESSAGE";
                }
            }
            for (n3 = 0; n3 != this.headerStart.length(); ++n3) {
                this.out.write(this.headerStart.charAt(n3));
            }
            for (n3 = 0; n3 != this.type.length(); ++n3) {
                this.out.write(this.type.charAt(n3));
            }
            for (n3 = 0; n3 != this.headerTail.length(); ++n3) {
                this.out.write(this.headerTail.charAt(n3));
            }
            for (n3 = 0; n3 != this.nl.length(); ++n3) {
                this.out.write(this.nl.charAt(n3));
            }
            if (this.headers.containsKey(VERSION_HDR)) {
                this.writeHeaderEntry(VERSION_HDR, (String)this.headers.get(VERSION_HDR));
            }
            Enumeration enumeration = this.headers.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals(VERSION_HDR)) continue;
                this.writeHeaderEntry(string, (String)this.headers.get(string));
            }
            for (int i = 0; i != this.nl.length(); ++i) {
                this.out.write(this.nl.charAt(i));
            }
            this.start = false;
        }
        if (this.bufPtr == 3) {
            this.encode(this.out, this.buf, this.bufPtr);
            this.bufPtr = 0;
            if ((++this.chunkCount & 0xF) == 0) {
                for (n2 = 0; n2 != this.nl.length(); ++n2) {
                    this.out.write(this.nl.charAt(n2));
                }
            }
        }
        this.crc.update(n);
        this.buf[this.bufPtr++] = n & 0xFF;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.type != null) {
            int n;
            int n2;
            this.encode(this.out, this.buf, this.bufPtr);
            for (n2 = 0; n2 != this.nl.length(); ++n2) {
                this.out.write(this.nl.charAt(n2));
            }
            this.out.write(61);
            n2 = this.crc.getValue();
            this.buf[0] = n2 >> 16 & 0xFF;
            this.buf[1] = n2 >> 8 & 0xFF;
            this.buf[2] = n2 & 0xFF;
            this.encode(this.out, this.buf, 3);
            for (n = 0; n != this.nl.length(); ++n) {
                this.out.write(this.nl.charAt(n));
            }
            for (n = 0; n != this.footerStart.length(); ++n) {
                this.out.write(this.footerStart.charAt(n));
            }
            for (n = 0; n != this.type.length(); ++n) {
                this.out.write(this.type.charAt(n));
            }
            for (n = 0; n != this.footerTail.length(); ++n) {
                this.out.write(this.footerTail.charAt(n));
            }
            for (n = 0; n != this.nl.length(); ++n) {
                this.out.write(this.nl.charAt(n));
            }
            this.out.flush();
            this.type = null;
            this.start = true;
        }
    }
}

