/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.EnumValueSnapshot;

public class IsolatableEnumValueSnapshot
extends EnumValueSnapshot
implements Isolatable<Enum> {
    private final Enum<?> value;

    public IsolatableEnumValueSnapshot(Enum<?> value) {
        super(value);
        this.value = value;
    }

    @Override
    public Enum isolate() {
        return this.value;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        if (type.isAssignableFrom(this.value.getClass())) {
            return (Isolatable)Cast.uncheckedCast((Object)this);
        }
        if (type.isEnum() && type.getName().equals(this.value.getClass().getName())) {
            return (Isolatable)Cast.uncheckedCast((Object)new IsolatableEnumValueSnapshot(Enum.valueOf(type.asSubclass(Enum.class), this.value.name())));
        }
        return null;
    }
}

