/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import java.nio.charset.Charset;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.resources.ApiTextResourceAdapter;
import org.gradle.api.internal.resources.FileCollectionBackedArchiveTextResource;
import org.gradle.api.internal.resources.FileCollectionBackedTextResource;
import org.gradle.api.internal.resources.StringBackedTextResource;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.internal.resource.TextResourceLoader;

public class DefaultTextResourceFactory
implements TextResourceFactory {
    private final FileOperations fileOperations;
    private final TemporaryFileProvider tempFileProvider;
    private final TextResourceLoader textResourceLoader;

    public DefaultTextResourceFactory(FileOperations fileOperations, TemporaryFileProvider tempFileProvider, TextResourceLoader textResourceLoader) {
        this.fileOperations = fileOperations;
        this.tempFileProvider = tempFileProvider;
        this.textResourceLoader = textResourceLoader;
    }

    public TextResource fromString(String string) {
        return new StringBackedTextResource(this.tempFileProvider, string);
    }

    public TextResource fromFile(Object file, String charset) {
        return new FileCollectionBackedTextResource(this.tempFileProvider, this.fileOperations.immutableFiles(file), Charset.forName(charset));
    }

    public TextResource fromFile(Object file) {
        return this.fromFile(file, Charset.defaultCharset().name());
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath, String charset) {
        return new FileCollectionBackedArchiveTextResource(this.fileOperations, this.tempFileProvider, this.fileOperations.immutableFiles(archive), entryPath, Charset.forName(charset));
    }

    public TextResource fromArchiveEntry(Object archive, String entryPath) {
        return this.fromArchiveEntry(archive, entryPath, Charset.defaultCharset().name());
    }

    public TextResource fromUri(Object uri) {
        return new ApiTextResourceAdapter(this.textResourceLoader, this.tempFileProvider, this.fileOperations.uri(uri));
    }
}

