/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"




main (int argc, char *argv[])
{

	matrix_TYP *Mat, *R;
        matrix_TYP *SV;
        int denomin, length, anz, i;

        extern char **FILENAMES;
        extern int FILEANZ;

	extern matrix_TYP *get_mat ();
	extern matrix_TYP *rest_short();
	extern void put_mat ();

        read_header(argc, argv);
        if(FILEANZ != 2)
        {
          printf("usage: Rest_short 'file1' 'file2' [-l=n -m=n -f -c -n],\n");
          printf("where 'file1' contains a positive definite symmetric matrix\n");
          printf("and   'file2' contains a matrix\n");
          if (is_option('h')){
             exit(0);
          }
          else{
             exit(31);
          }
        }
	Mat = get_mat (FILENAMES[0]);
        R = get_mat(FILENAMES[1]);
        length = optionnumber('l');
        if(length == 0)
          length = 1;
        denomin = optionnumber('d');
        if(denomin == 0)
           denomin = 1;
        for(i=0;i<R->rows;i++)
        {
          SV = rest_short(Mat, R->array.SZ[i], R->kgv, length, denomin,is_option('f'), is_option('c'), &anz);
          if(is_option('c') == TRUE)
          {
            printf("#%d  Anzahl der Vektoren mit Quadratabstand kleiner %d/%d\n", anz, denomin, length);
          }
          else
          {
            if(is_option('n') == TRUE)
               SV->cols++;
            put_mat(SV, NULL, "shortest vectors", 0);
            free_mat(SV);
          }
        }

   exit(0);
}
