/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.telephony;

import a_vcard.android.telephony.JapanesePhoneNumberFormatter;
import a_vcard.android.text.Editable;
import a_vcard.android.text.SpannableStringBuilder;
import java.util.Locale;

public class PhoneNumberUtils {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_NANP = 1;
    public static final int FORMAT_JAPAN = 2;
    private static final String[] NANP_COUNTRIES = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "NP", "KN", "LC", "VC", "TT", "TC", "VI"};
    private static final int NANP_STATE_DIGIT = 1;
    private static final int NANP_STATE_PLUS = 2;
    private static final int NANP_STATE_ONE = 3;
    private static final int NANP_STATE_DASH = 4;

    public static String formatNumber(String source) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, PhoneNumberUtils.getFormatTypeForLocale(Locale.getDefault()));
        return text.toString();
    }

    public static int getFormatTypeForLocale(Locale locale) {
        String country = locale.getCountry();
        int length = NANP_COUNTRIES.length;
        for (int i = 0; i < length; ++i) {
            if (!NANP_COUNTRIES[i].equals(country)) continue;
            return 1;
        }
        if (locale.equals(Locale.JAPAN)) {
            return 2;
        }
        return 0;
    }

    public static void formatNumber(Editable text, int defaultFormattingType) {
        int formatType = defaultFormattingType;
        if (text.length() > 2 && text.charAt(0) == '+') {
            if (text.charAt(1) == '1') {
                formatType = 1;
            } else if (text.length() >= 3 && text.charAt(1) == '8' && text.charAt(2) == '1') {
                formatType = 2;
            } else {
                return;
            }
        }
        switch (formatType) {
            case 1: {
                PhoneNumberUtils.formatNanpNumber(text);
                return;
            }
            case 2: {
                PhoneNumberUtils.formatJapaneseNumber(text);
                return;
            }
        }
    }

    public static void formatNanpNumber(Editable text) {
        int i;
        int length = text.length();
        if (length > "+1-nnn-nnn-nnnn".length()) {
            return;
        }
        CharSequence saved = text.subSequence(0, length);
        int p = 0;
        while (p < text.length()) {
            if (text.charAt(p) == '-') {
                text.delete(p, p + 1);
                continue;
            }
            ++p;
        }
        length = text.length();
        int[] dashPositions = new int[3];
        int numDashes = 0;
        int state = 1;
        int numDigits = 0;
        block7: for (i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '1': {
                    if (numDigits == 0 || state == 2) {
                        state = 3;
                        continue block7;
                    }
                }
                case '0': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 2) {
                        text.replace(0, length, saved);
                        return;
                    }
                    if (state == 3) {
                        dashPositions[numDashes++] = i;
                    } else if (state != 4 && (numDigits == 3 || numDigits == 6)) {
                        dashPositions[numDashes++] = i;
                    }
                    state = 1;
                    ++numDigits;
                    continue block7;
                }
                case '-': {
                    state = 4;
                    continue block7;
                }
                case '+': {
                    if (i == 0) {
                        state = 2;
                        continue block7;
                    }
                }
                default: {
                    text.replace(0, length, saved);
                    return;
                }
            }
        }
        if (numDigits == 7) {
            --numDashes;
        }
        for (i = 0; i < numDashes; ++i) {
            int pos = dashPositions[i];
            text.replace(pos + i, pos + i, "-");
        }
        for (int len = text.length(); len > 0 && text.charAt(len - 1) == '-'; --len) {
            text.delete(len - 1, len);
        }
    }

    public static void formatJapaneseNumber(Editable text) {
        JapanesePhoneNumberFormatter.format(text);
    }
}

