/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.core;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.ptp.internal.rdt.sync.git.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.core.EclipseGitProgressTransformer;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitRepo;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitSyncFileFilter;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitSyncService;
import org.eclipse.ptp.internal.rdt.sync.git.core.SyncFileTreeIterator;
import org.eclipse.ptp.internal.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.RemoteLocation;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public class JGitRepo {
    public static final String remoteBranchName = "eclipse_auto";
    public static final String EMPTY_FILE_NAME = ".ptp-sync-folder";
    private final IPath localDirectory;
    private Git git;
    private GitSyncFileFilter fileFilter = null;
    private boolean mergeMapInitialized = false;
    private final Map<IPath, String[]> fileToMergePartsMap = new HashMap<IPath, String[]>();
    private final Map<RemoteLocation, TransportGitSsh> remoteToTransportMap = new HashMap<RemoteLocation, TransportGitSsh>();

    public JGitRepo(IPath localDir, IProgressMonitor monitor) throws GitAPIException, IOException {
        this.localDirectory = localDir;
        try {
            this.buildRepo(this.localDirectory.toOSString(), monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean anyDiffInIndex() throws IOException {
        Repository repo = this.getRepository();
        TreeWalk treeWalk = new TreeWalk(repo);
        treeWalk.setRecursive(true);
        ObjectId rev = repo.resolve("HEAD");
        if (rev != null) {
            treeWalk.addTree((AnyObjectId)new RevWalk(repo).parseTree((AnyObjectId)rev));
        }
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        return treeWalk.next();
    }

    private Git buildRepo(String localDirectory, IProgressMonitor monitor) throws GitAPIException, IOException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            File localDir = new File(localDirectory);
            FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
            File gitDirFile = new File(String.valueOf(localDirectory) + File.separator + ".ptp-sync");
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)repoBuilder.setWorkTree(localDir)).setGitDir(gitDirFile)).build();
            boolean repoExists = gitDirFile.exists();
            if (!repoExists) {
                repository.create(false);
            }
            this.git = new Git(repository);
            if (!repoExists) {
                this.fileFilter = new GitSyncFileFilter(this, (AbstractSyncFileFilter)SyncManager.getDefaultFileFilter());
                this.fileFilter.saveFilter();
            } else {
                this.fileFilter = new GitSyncFileFilter(this);
                this.fileFilter.loadFilter();
            }
            subMon.worked(5);
            subMon.subTask(Messages.JGitRepo_0);
            if (!repoExists) {
                this.commit((IProgressMonitor)subMon.newChild(4));
            } else {
                subMon.worked(4);
            }
            Git git = this.git;
            return git;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private RemoteConfig buildRemoteConfig(StoredConfig config) {
        RemoteConfig rconfig = null;
        try {
            rconfig = new RemoteConfig((Config)config, remoteBranchName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RefSpec refSpecFetch = new RefSpec("+refs/heads/master:refs/remotes/eclipse_auto/master");
        RefSpec refSpecPush = new RefSpec("+master:ptp-push");
        rconfig.addFetchRefSpec(refSpecFetch);
        rconfig.addPushRefSpec(refSpecPush);
        return rconfig;
    }

    public void checkout(IPath[] paths) throws GitAPIException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            checkoutCommand.addPath(p.toString());
            ++n2;
        }
        checkoutCommand.setStartPoint("HEAD");
        checkoutCommand.call();
    }

    public void checkoutRemoteCopy(IPath[] paths) throws GitAPIException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            checkoutCommand.addPath(p.toString());
            ++n2;
        }
        checkoutCommand.setStartPoint("refs/remotes/eclipse_auto/master");
        checkoutCommand.call();
    }

    public boolean commit(IProgressMonitor monitor) throws GitAPIException, IOException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        assert (!this.inUnresolvedMergeState());
        try {
            GitSyncFileFilter.DiffFiles diffFiles = this.fileFilter.getDiffFiles();
            for (String dirName : diffFiles.dirSet) {
                File emptyFile;
                boolean fileWasCreated;
                Path emptyFilePath = new Path(this.getRepository().getWorkTree().getAbsolutePath());
                File emptyFileDir = new File((emptyFilePath = emptyFilePath.append(dirName)).toOSString());
                if (!emptyFileDir.exists() || !(fileWasCreated = (emptyFile = new File((emptyFilePath = emptyFilePath.append(EMPTY_FILE_NAME)).toOSString())).createNewFile())) continue;
                diffFiles.added.add(emptyFilePath.toString());
            }
            subMon.subTask(Messages.JGitRepo_2);
            if (!diffFiles.added.isEmpty()) {
                AddCommand addCommand = this.git.add();
                addCommand.setWorkingTreeIterator((WorkingTreeIterator)new SyncFileTreeIterator(this.git.getRepository(), this.fileFilter));
                for (String fileName : diffFiles.added) {
                    addCommand.addFilepattern(fileName);
                }
                addCommand.call();
            }
            subMon.worked(3);
            subMon.subTask(Messages.JGitRepo_3);
            if (!diffFiles.removed.isEmpty()) {
                RmCommand rmCommand = new RmCommand(this.git.getRepository());
                rmCommand.setCached(true);
                for (String fileName : diffFiles.removed) {
                    rmCommand.addFilepattern(fileName);
                }
                rmCommand.call();
            }
            subMon.worked(3);
            subMon.subTask(Messages.JGitRepo_4);
            if (this.anyDiffInIndex() || this.inMergeState()) {
                CommitCommand commitCommand = this.git.commit();
                commitCommand.setMessage(GitSyncService.commitMessage);
                commitCommand.call();
                return true;
            }
            return false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    boolean commitExists(String commitId) throws RevisionSyntaxException, AmbiguousObjectException, IncorrectObjectTypeException, IOException {
        ObjectId commitObjectId = this.getRepository().resolve(commitId);
        return this.getRepository().hasObject((AnyObjectId)commitObjectId);
    }

    public void fetch(GitRepo remoteRepo, IProgressMonitor monitor) throws TransportException {
        RemoteLocation remoteLoc = remoteRepo.getRemoteLocation();
        int work = 10;
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)work);
        TransportGitSsh transport = this.remoteToTransportMap.get(remoteLoc);
        if (transport == null) {
            subMon.subTask(Messages.JGitRepo_5);
            transport = this.buildTransport(remoteLoc, (IProgressMonitor)subMon.newChild(work /= 2));
            this.remoteToTransportMap.put(remoteLoc, transport);
        }
        try {
            subMon.subTask(Messages.JGitRepo_6);
            String uploadCommand = String.valueOf(remoteRepo.gitBinary()) + " upload-pack";
            transport.setOptionUploadPack(uploadCommand);
            transport.fetch((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(work)), null);
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void push(GitRepo remoteRepo, IProgressMonitor monitor) throws TransportException {
        RemoteLocation remoteLoc = remoteRepo.getRemoteLocation();
        int work = 10;
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)work);
        TransportGitSsh transport = this.remoteToTransportMap.get(remoteLoc);
        if (transport == null) {
            subMon.subTask(Messages.JGitRepo_5);
            transport = this.buildTransport(remoteLoc, (IProgressMonitor)subMon.newChild(work /= 2));
            this.remoteToTransportMap.put(remoteLoc, transport);
        }
        try {
            subMon.subTask(Messages.JGitRepo_8);
            String receiveCommand = String.valueOf(remoteRepo.gitBinary()) + " receive-pack";
            transport.setOptionReceivePack(receiveCommand);
            transport.push((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(work)), null);
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean inMergeState() throws IOException {
        try {
            return this.git.getRepository().resolve("MERGE_HEAD") != null;
        }
        catch (AmbiguousObjectException e) {
            Activator.log(e);
            return true;
        }
    }

    public boolean inUnresolvedMergeState() throws IOException {
        return this.inMergeState() && !this.git.getRepository().getRepositoryState().equals((Object)RepositoryState.MERGING_RESOLVED);
    }

    public boolean readMergeConflictFiles(IProgressMonitor monitor) throws GitAPIException, IOException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String repoPath = this.git.getRepository().getWorkTree().getAbsolutePath();
        if (!repoPath.endsWith(File.separator)) {
            repoPath = String.valueOf(repoPath) + File.separator;
        }
        this.fileToMergePartsMap.clear();
        this.mergeMapInitialized = true;
        RevWalk walk = null;
        try {
            if (!this.git.getRepository().getRepositoryState().equals((Object)RepositoryState.MERGING)) {
                return false;
            }
            subMon.subTask(Messages.JGitRepo_9);
            StatusCommand statusCommand = this.git.status();
            Status status = statusCommand.call();
            if (status.getConflicting().isEmpty()) {
                return false;
            }
            subMon.worked(30);
            subMon.subTask(Messages.JGitRepo_10);
            walk = new RevWalk(this.git.getRepository());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            ObjectId headSHA = this.git.getRepository().resolve("HEAD");
            ObjectId mergeHeadSHA = this.git.getRepository().resolve("MERGE_HEAD");
            RevCommit head = walk.parseCommit((AnyObjectId)headSHA);
            RevCommit mergeHead = walk.parseCommit((AnyObjectId)mergeHeadSHA);
            walk.markStart(head);
            walk.markStart(mergeHead);
            RevCommit mergeBase = walk.next();
            subMon.worked(30);
            subMon.subTask(Messages.JGitRepo_11);
            for (String s : status.getConflicting()) {
                TreeWalk ancestorTreeWalk;
                String localContents = "";
                TreeWalk localTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)head.getTree());
                if (localTreeWalk != null) {
                    ObjectId localId = localTreeWalk.getObjectId(0);
                    localContents = new String(this.git.getRepository().open((AnyObjectId)localId).getBytes());
                }
                String remoteContents = "";
                TreeWalk remoteTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)mergeHead.getTree());
                if (remoteTreeWalk != null) {
                    ObjectId remoteId = remoteTreeWalk.getObjectId(0);
                    remoteContents = new String(this.git.getRepository().open((AnyObjectId)remoteId).getBytes());
                }
                String ancestorContents = "";
                if (mergeBase != null && (ancestorTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)mergeBase.getTree())) != null) {
                    ObjectId ancestorId = ancestorTreeWalk.getObjectId(0);
                    ancestorContents = new String(this.git.getRepository().open((AnyObjectId)ancestorId).getBytes());
                }
                String[] mergeParts = new String[]{localContents, remoteContents, ancestorContents};
                this.fileToMergePartsMap.put((IPath)new Path(s), mergeParts);
            }
            subMon.worked(40);
        }
        finally {
            if (walk != null) {
                walk.dispose();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return this.fileToMergePartsMap.isEmpty();
    }

    public IPath getDirectory() {
        return this.localDirectory;
    }

    public GitSyncFileFilter getFilter() {
        return this.fileFilter;
    }

    public Git getGit() {
        return this.git;
    }

    public Repository getRepository() {
        return this.git.getRepository();
    }

    public Set<IPath> getMergeConflictFiles() throws GitAPIException, IOException {
        if (!this.mergeMapInitialized) {
            this.readMergeConflictFiles(null);
        }
        return this.fileToMergePartsMap.keySet();
    }

    public String[] getMergeConflictParts(IPath localFile) throws GitAPIException, IOException {
        if (!this.mergeMapInitialized) {
            this.readMergeConflictFiles(null);
        }
        return this.fileToMergePartsMap.get(localFile);
    }

    public MergeResult merge(IProgressMonitor monitor) throws IOException, GitAPIException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Ref remoteMasterRef = this.git.getRepository().findRef("refs/remotes/eclipse_auto/master");
            MergeCommand mergeCommand = this.git.merge().include(remoteMasterRef);
            subMon.subTask(Messages.JGitRepo_12);
            this.mergeMapInitialized = false;
            MergeResult mergeResult = mergeCommand.call();
            return mergeResult;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void setFilter(AbstractSyncFileFilter filter) {
        this.fileFilter = new GitSyncFileFilter(this);
        this.fileFilter.initialize(filter);
        try {
            this.fileFilter.saveFilter();
        }
        catch (IOException e) {
            Activator.log(String.valueOf(Messages.JGitRepo_13) + this.localDirectory, e);
        }
    }

    public void setMergeAsResolved(IPath[] paths) throws GitAPIException {
        AddCommand addCommand = this.git.add();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            addCommand.addFilepattern(p.toString());
            ++n2;
        }
        addCommand.call();
        StatusCommand statusCommand = this.git.status();
        Status status = statusCommand.call();
        IPath[] iPathArray2 = paths;
        int n3 = paths.length;
        int n4 = 0;
        while (n4 < n3) {
            IPath p = iPathArray2[n4];
            if (!status.getConflicting().contains(p.toString())) {
                this.fileToMergePartsMap.remove(p);
            }
            ++n4;
        }
    }

    private TransportGitSsh buildTransport(final RemoteLocation remoteLoc, IProgressMonitor monitor) throws TransportException {
        TransportGitSsh transport;
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        RemoteConfig remoteConfig = this.buildRemoteConfig(this.git.getRepository().getConfig());
        URIish uri = this.buildURI(remoteLoc.getDirectory());
        try {
            try {
                subMon.subTask(Messages.JGitRepo_15);
                transport = (TransportGitSsh)Transport.open((Repository)this.git.getRepository(), (URIish)uri);
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        transport.setSshSessionFactory(new SshSessionFactory(){

            public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
                return new PTPSession(remoteLoc);
            }
        });
        transport.applyConfig(remoteConfig);
        return transport;
    }

    private URIish buildURI(String directory) {
        return new URIish().setHost("none").setScheme("ssh").setPath(String.valueOf(directory) + "/" + ".ptp-sync");
    }

    public void close() {
        for (TransportGitSsh t : this.remoteToTransportMap.values()) {
            t.close();
        }
        this.remoteToTransportMap.clear();
        this.git.getRepository().close();
        this.git = null;
        this.fileFilter = null;
        this.fileToMergePartsMap.clear();
    }

    private class PTPSession
    implements RemoteSession {
        private final RemoteLocation remoteLoc;
        private final URIish uri;

        public PTPSession(RemoteLocation remoteLoc) {
            this.remoteLoc = remoteLoc;
            this.uri = JGitRepo.this.buildURI(remoteLoc.getDirectory());
        }

        public Process exec(String command, int timeout) throws TransportException {
            LinkedList<String> commandList = new LinkedList<String>();
            commandList.add("sh");
            commandList.add("-c");
            commandList.add(command);
            try {
                IRemoteConnection connection = this.remoteLoc.getConnection();
                if (!connection.isOpen()) {
                    connection.open(null);
                }
                return (Process)((IRemoteProcessService)connection.getService(IRemoteProcessService.class)).getProcessBuilder(commandList).start();
            }
            catch (IOException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (MissingConnectionException e) {
                throw new TransportException(this.uri, String.valueOf(Messages.JGitRepo_14) + e.getConnectionName(), (Throwable)e);
            }
        }

        public void disconnect() {
        }
    }
}

