/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Optional;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.ui.internal.util.action.CommandBackedAction;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.internal.view.task.TaskNodeSelectionUtils;
import org.eclipse.buildship.ui.internal.view.task.TaskViewActionStateRules;
import org.eclipse.buildship.ui.internal.view.task.TaskViewMessages;

public final class OpenRunConfigurationAction
extends CommandBackedAction
implements SelectionSpecificAction {
    public OpenRunConfigurationAction(String commandId) {
        super(commandId);
        this.setText(TaskViewMessages.Action_OpenRunConfiguration_Text);
        this.setToolTipText(TaskViewMessages.Action_OpenRunConfiguration_Tooltip);
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        return (TaskViewActionStateRules.taskScopedTaskExecutionActionsVisibleFor(selection) || TaskViewActionStateRules.projectScopedTaskExecutionActionsVisibleFor(selection)) && this.isValidSelection(selection);
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        return (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(selection).asBoolean() || TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) && this.isValidSelection(selection);
    }

    private boolean isValidSelection(NodeSelection selection) {
        Optional<GradleRunConfigurationAttributes> attributes = TaskNodeSelectionUtils.tryGetRunConfigurationAttributes(selection);
        return attributes.isPresent() && CorePlugin.gradleLaunchConfigurationManager().getRunConfiguration((GradleRunConfigurationAttributes)attributes.get()).isPresent();
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }
}

