/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.data;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.dbeaver.ui.search.AbstractSearchPage;
import org.jkiss.dbeaver.ui.search.data.DatabaseObjectsTreeManager;
import org.jkiss.dbeaver.ui.search.data.SearchDataParams;
import org.jkiss.dbeaver.ui.search.data.SearchDataQuery;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SearchDataPage
extends AbstractSearchPage {
    private static final String PROP_MASK = "search.data.mask";
    private static final String PROP_CASE_SENSITIVE = "search.data.case-sensitive";
    private static final String PROP_SAMPLE_ROWS = "search.data.sample-rows";
    private static final String PROP_FAST_SEARCH = "search.data.fast-search";
    private static final String PROP_SEARCH_NUMBERS = "search.data.search-numbers";
    private static final String PROP_SEARCH_LOBS = "search.data.search-lobs";
    private static final String PROP_SEARCH_FOREIGN = "search.data.search-foreign";
    private static final String PROP_HISTORY = "search.data.history";
    private Combo searchText;
    private DatabaseNavigatorTree dataSourceTree;
    private SearchDataParams params = new SearchDataParams();
    private Set<String> searchHistory = new LinkedHashSet<String>();
    private DatabaseObjectsTreeManager checkboxTreeManager;
    private static final Map<Class<? extends AbstractSearchPage>, String> searchStateCache = new IdentityHashMap<Class<? extends AbstractSearchPage>, String>();

    public SearchDataPage() {
        super("Database objects search");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeDialogUnits((Control)parent);
        Composite searchGroup = new Composite(parent, 0);
        searchGroup.setLayoutData((Object)new GridData(1808));
        searchGroup.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)searchGroup);
        UIUtils.createControlLabel((Composite)searchGroup, (String)"String");
        this.searchText = new Combo(searchGroup, 4);
        this.searchText.setLayoutData((Object)new GridData(768));
        if (this.params.searchString != null) {
            this.searchText.setText(this.params.searchString);
        }
        for (String history : this.searchHistory) {
            this.searchText.add(history);
        }
        this.searchText.addModifyListener(e -> {
            this.params.searchString = this.searchText.getText();
            this.updateEnablement();
        });
        SashForm optionsGroup = new SashForm(searchGroup, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        optionsGroup.setLayoutData((Object)gd);
        DBeaverCore core = DBeaverCore.getInstance();
        Group databasesGroup = UIUtils.createControlGroup((Composite)optionsGroup, (String)"Databases", (int)1, (int)1808, (int)0);
        gd = new GridData(1808);
        databasesGroup.setLayoutData((Object)gd);
        DBNProject projectNode = core.getNavigatorModel().getRoot().getProject(core.getProjectRegistry().getActiveProject());
        DBNProjectDatabases rootNode = projectNode == null ? core.getNavigatorModel().getRoot() : projectNode.getDatabases();
        this.dataSourceTree = new DatabaseNavigatorTree((Composite)databasesGroup, (DBNNode)rootNode, 36);
        gd = new GridData(1808);
        gd.heightHint = 300;
        this.dataSourceTree.setLayoutData((Object)gd);
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.dataSourceTree.getViewer();
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        Class folderItemsClass = folder.getChildrenClass();
                        return folderItemsClass != null && (DBSObjectContainer.class.isAssignableFrom(folderItemsClass) || DBSEntity.class.isAssignableFrom(folderItemsClass));
                    }
                    if (element instanceof DBNLocalFolder || element instanceof DBNProjectDatabases || element instanceof DBNDataSource) {
                        return true;
                    }
                    if (element instanceof DBSWrapper) {
                        DBSObject obj = ((DBSWrapper)element).getObject();
                        if (obj instanceof DBSObjectContainer) {
                            return true;
                        }
                        if (obj instanceof DBSDataContainer && obj instanceof DBSEntity && (((DBSDataContainer)obj).getSupportedFeatures() & 0x10) != 0) {
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        this.checkboxTreeManager = new DatabaseObjectsTreeManager((DBRRunnableContext)new RunnableContextDelegate(this.container.getRunnableContext()), viewer, new Class[]{DBSDataContainer.class});
        viewer.addCheckStateListener(event -> this.updateEnablement());
        Group optionsGroup2 = UIUtils.createControlGroup((Composite)optionsGroup, (String)"Settings", (int)2, (int)768, (int)0);
        optionsGroup2.setLayoutData((Object)new GridData(802));
        if (this.params.maxResults <= 0) {
            this.params.maxResults = 10;
        }
        Spinner maxResultsSpinner = UIUtils.createLabelSpinner((Composite)optionsGroup2, (String)"Sample rows", (String)"Maximum number of rows to search. Don't set to a big number, this might greatly reduce search performance.", (int)this.params.maxResults, (int)1, (int)Integer.MAX_VALUE);
        maxResultsSpinner.setLayoutData((Object)new GridData(32));
        maxResultsSpinner.addModifyListener(e -> {
            int n = this.params.maxResults = maxResultsSpinner.getSelection();
        });
        final Button caseCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)CoreMessages.dialog_search_objects_case_sensitive, (String)"Case sensitive search", (boolean)this.params.caseSensitive, (int)2);
        caseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SearchDataPage)SearchDataPage.this).params.caseSensitive = caseCheckbox.getSelection();
            }
        });
        final Button fastSearchCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)"Fast search (indexed)", (String)"Search only in indexed columns", (boolean)this.params.fastSearch, (int)2);
        fastSearchCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SearchDataPage)SearchDataPage.this).params.fastSearch = fastSearchCheckbox.getSelection();
            }
        });
        final Button searchNumbersCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)"Search in numbers", (String)"Search in numeric columns (search value must be a number)", (boolean)this.params.searchNumbers, (int)2);
        searchNumbersCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SearchDataPage)SearchDataPage.this).params.searchNumbers = searchNumbersCheckbox.getSelection();
            }
        });
        Button searchLOBCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)"Search in LOBs", (String)"Search in BLOB/CLOB/binary columns", (boolean)this.params.searchLOBs, (int)2);
        searchLOBCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SearchDataPage)SearchDataPage.this).params.searchLOBs = searchNumbersCheckbox.getSelection();
            }
        });
        final Button searchForeignCheckbox = UIUtils.createCheckbox((Composite)optionsGroup2, (String)"Search in foreign objects", (String)"Search in foreign tables or DB links. Searching in such tables may cause performance issues.", (boolean)this.params.searchForeignObjects, (int)2);
        searchForeignCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SearchDataPage)SearchDataPage.this).params.searchForeignObjects = searchForeignCheckbox.getSelection();
            }
        });
        UIUtils.asyncExec(this::restoreCheckedNodes);
        if (!this.params.selectedNodes.isEmpty()) {
            this.dataSourceTree.getViewer().setSelection((ISelection)new StructuredSelection(this.params.selectedNodes), true);
        }
        this.dataSourceTree.setEnabled(true);
    }

    @Override
    public SearchDataQuery createQuery() throws DBException {
        this.params.sources = this.getCheckedSources();
        if (!this.searchHistory.contains(this.params.searchString)) {
            this.searchHistory.add(this.params.searchString);
            this.searchText.add(this.params.searchString);
        }
        return SearchDataQuery.createQuery(this.params);
    }

    @Override
    public void loadState(DBPPreferenceStore store) {
        String history;
        this.params.searchString = store.getString(PROP_MASK);
        this.params.caseSensitive = store.getBoolean(PROP_CASE_SENSITIVE);
        this.params.fastSearch = store.getBoolean(PROP_FAST_SEARCH);
        this.params.searchNumbers = store.getString(PROP_SEARCH_NUMBERS) == null || store.getBoolean(PROP_SEARCH_NUMBERS);
        this.params.searchLOBs = store.getBoolean(PROP_SEARCH_LOBS);
        this.params.searchForeignObjects = store.getBoolean(PROP_SEARCH_FOREIGN);
        this.params.maxResults = store.getInt(PROP_SAMPLE_ROWS);
        int i = 0;
        while (!CommonUtils.isEmpty((String)(history = store.getString("search.data.history." + i)))) {
            this.searchHistory.add(history);
            ++i;
        }
        this.params.selectedNodes.clear();
        ISelection selection = this.container.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selItem = objectArray[n2];
                if (selItem instanceof DBNNode) {
                    this.params.selectedNodes.add((DBNNode)selItem);
                }
                ++n2;
            }
        }
    }

    @Override
    public void saveState(DBPPreferenceStore store) {
        store.setValue(PROP_MASK, this.params.searchString);
        store.setValue(PROP_CASE_SENSITIVE, this.params.caseSensitive);
        store.setValue(PROP_SAMPLE_ROWS, this.params.maxResults);
        store.setValue(PROP_FAST_SEARCH, this.params.fastSearch);
        store.setValue(PROP_SEARCH_NUMBERS, this.params.searchNumbers);
        store.setValue(PROP_SEARCH_LOBS, this.params.searchLOBs);
        store.setValue(PROP_SEARCH_FOREIGN, this.params.searchForeignObjects);
        this.saveTreeState(this.dataSourceTree);
        int historyIndex = 0;
        for (String history : this.searchHistory) {
            if (historyIndex >= 20) break;
            store.setValue("search.data.history." + historyIndex, history);
            ++historyIndex;
        }
    }

    private List<DBSDataContainer> getCheckedSources() {
        ArrayList<DBSDataContainer> result = new ArrayList<DBSDataContainer>();
        Object[] objectArray = ((CheckboxTreeViewer)this.dataSourceTree.getViewer()).getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject object;
            Object sel = objectArray[n2];
            if (sel instanceof DBSWrapper && (object = ((DBSWrapper)sel).getObject()) instanceof DBSDataContainer && object.getDataSource() != null) {
                result.add((DBSDataContainer)object);
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void updateEnablement() {
        boolean enabled = false;
        if (!ArrayUtils.isEmpty((Object[])((CheckboxTreeViewer)this.dataSourceTree.getViewer()).getCheckedElements())) {
            enabled = true;
        }
        this.container.setPerformActionEnabled(enabled);
    }

    protected void saveTreeState(DatabaseNavigatorTree tree) {
        StringBuilder sourcesString = new StringBuilder();
        Object[] objectArray = ((CheckboxTreeViewer)tree.getViewer()).getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            DBNNode node = (DBNNode)obj;
            if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof DBSDataContainer) {
                if (sourcesString.length() > 0) {
                    sourcesString.append("|");
                }
                sourcesString.append(node.getNodeItemPath());
            }
            ++n2;
        }
        searchStateCache.put(((Object)((Object)this)).getClass(), sourcesString.toString());
    }

    protected List<DBNNode> loadTreeState(DBRProgressMonitor monitor) {
        String sources = searchStateCache.get(((Object)((Object)this)).getClass());
        return this.loadTreeState(monitor, sources);
    }

    private void restoreCheckedNodes() {
        ArrayList checkedNodes = new ArrayList();
        try {
            this.container.getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask("Load database nodes", 1);
                try {
                    monitor.subTask("Load tree state");
                    checkedNodes.addAll(this.loadTreeState((DBRProgressMonitor)new DefaultProgressMonitor(monitor)));
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data sources load", "Error loading settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (!checkedNodes.isEmpty()) {
            boolean first = true;
            for (DBNNode node : checkedNodes) {
                ((CheckboxTreeViewer)this.dataSourceTree.getViewer()).setChecked((Object)node, true);
                if (!first) continue;
                DBNDataSource dsNode = DBNDataSource.getDataSourceNode((DBNNode)node);
                if (dsNode != null) {
                    this.dataSourceTree.getViewer().reveal((Object)dsNode);
                }
                first = false;
            }
            this.checkboxTreeManager.updateCheckStates();
            this.updateEnablement();
        }
    }
}

