/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.maintenance;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreToolTriggerToggle
implements IExternalTool {
    private boolean isEnable;

    protected PostgreToolTriggerToggle(boolean enable) {
        this.isEnable = enable;
    }

    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        SQLDialog dialog;
        List triggeList = CommonUtils.filterCollection(objects, PostgreTrigger.class);
        if (!triggeList.isEmpty() && (dialog = new SQLDialog(activePart.getSite(), triggeList)).open() == 0) {
            this.refreshObjectsState(triggeList);
        }
    }

    private void refreshObjectsState(List<PostgreTrigger> triggeList) {
        try {
            UIUtils.runInProgressDialog(monitor -> {
                for (PostgreTrigger trigger : triggeList) {
                    try {
                        DBNDatabaseNode triggerNode = NavigatorUtils.getNodeByObject((DBSObject)trigger);
                        if (triggerNode != null) {
                            triggerNode.refreshNode(monitor, (Object)this);
                            continue;
                        }
                        trigger.refreshObjectState(monitor);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Refresh triggers state", "Error refreshign trigger state", e.getTargetException());
        }
    }

    class SQLDialog
    extends TableToolDialog {
        public SQLDialog(IWorkbenchPartSite partSite, List<PostgreTrigger> selectedTrigger) {
            super(partSite, String.valueOf(PostgreToolTriggerToggle.this.isEnable ? "Enable" : "Disable") + " trigger", selectedTrigger);
        }

        protected void generateObjectCommand(List<String> lines, PostgreObject object) {
            lines.add("ALTER TABLE " + ((PostgreTrigger)object).getTable() + " " + (PostgreToolTriggerToggle.this.isEnable ? "ENABLE" : "DISABLE") + " TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)object));
        }

        protected void createControls(Composite parent) {
            this.createObjectsSelector(parent);
        }
    }
}

