/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.application.DBeaverApplication;
import org.jkiss.dbeaver.model.runtime.BaseProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IOUtils;

class DBeaverSettingsImporter {
    private static final String[] COPY_PLUGINS = new String[]{"org.eclipse.compare", "org.eclipse.core.resources", "org.eclipse.core.runtime", "org.eclipse.e4.ui.workbench.swt", "org.eclipse.equinox.p2.ui", "org.eclipse.equinox.security.ui", "org.eclipse.help.ui", "org.eclipse.search", "org.eclipse.ui.ide", "org.eclipse.ui.views.log", "org.eclipse.ui.workbench", "org.eclipse.ui.workbench.texteditor", "org.jkiss.dbeaver.core", "org.jkiss.dbeaver.model"};
    private final DBeaverApplication application;
    private final Display display;
    private Shell windowShell;
    private Label progressLabel;
    private ProgressBar progressBar;
    private File driversFolder;
    private File oldWorkspacePath;
    private int shellResult = 0;

    public DBeaverSettingsImporter(DBeaverApplication application, Display display) {
        this.application = application;
        this.display = display;
    }

    boolean migrateFromPreviousVersion(final File oldDir, final File newDir) {
        Properties oldProps = DBeaverCore.readWorkspaceInfo((File)GeneralUtils.getMetadataFolder((File)oldDir));
        String oldVersion = oldProps.getProperty("product-version");
        if (oldVersion == null) {
            oldVersion = "3.x";
        }
        this.oldWorkspacePath = oldDir;
        this.driversFolder = new File(System.getProperty("user.home"), ".dbeaver-drivers");
        Image dbeaverIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.core.application", (String)"icons/dbeaver32.png").createImage();
        Image dbeaverLogo = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.core.application", (String)"icons/dbeaver64.png").createImage();
        this.windowShell = new Shell(this.display);
        this.windowShell.setImage(dbeaverIcon);
        this.windowShell.setText("Import " + GeneralUtils.getProductName() + " configuration");
        this.windowShell.setLayout((Layout)new GridLayout(1, false));
        Group infoGroup = new Group((Composite)this.windowShell, 0);
        infoGroup.setText("Import workspace");
        infoGroup.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        infoGroup.setLayout((Layout)gl);
        Label iconLabel = new Label((Composite)infoGroup, 0);
        iconLabel.setImage(dbeaverLogo);
        iconLabel.setLayoutData((Object)new GridData(2));
        Label confirmLabel = new Label((Composite)infoGroup, 0);
        confirmLabel.setText("Previous version (" + GeneralUtils.getProductName() + " " + oldVersion + ") settings were found:\n" + oldDir.getAbsolutePath() + "\n" + "Do you want to import these settings? (Recommended).\n\n" + "Make sure previous version of " + GeneralUtils.getProductName() + " isn't running");
        confirmLabel.setLayoutData((Object)new GridData(1808));
        Composite buttonsPanel = new Composite((Composite)this.windowShell, 0);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        buttonsPanel.setLayout((Layout)new GridLayout(2, true));
        final Button migrateButton = new Button(buttonsPanel, 8);
        migrateButton.setText("Import workspace");
        final Button skipButton = new Button(buttonsPanel, 8);
        skipButton.setText("Skip");
        migrateButton.setLayoutData((Object)new GridData(768));
        migrateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                migrateButton.setEnabled(false);
                skipButton.setEnabled(false);
                DBeaverSettingsImporter.this.progressBar.setVisible(true);
                ((GridData)((DBeaverSettingsImporter)DBeaverSettingsImporter.this).progressBar.getLayoutData()).exclude = false;
                DBeaverSettingsImporter.this.windowShell.pack();
                DBeaverSettingsImporter.this.migrateWorkspace(oldDir, newDir);
            }
        });
        skipButton.setLayoutData((Object)new GridData(768));
        skipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(DBeaverSettingsImporter.this.windowShell, 200);
                messageBox.setText("Skip workspace migration");
                messageBox.setMessage("Skipping workspace migration you will lose all previous workspace data.\n\nAre you sure?");
                int response = messageBox.open();
                if (response == 64) {
                    DBeaverSettingsImporter.this.shellResult = 2048;
                    DBeaverSettingsImporter.this.windowShell.dispose();
                }
            }
        });
        this.progressLabel = new Label((Composite)this.windowShell, 0);
        this.progressLabel.setLayoutData((Object)new GridData(1808));
        this.progressBar = new ProgressBar((Composite)this.windowShell, 65536);
        this.progressBar.setVisible(false);
        GridData gd = new GridData(1808);
        gd.heightHint = 30;
        gd.widthHint = 300;
        gd.exclude = true;
        this.progressBar.setLayoutData((Object)gd);
        this.windowShell.pack();
        Rectangle screenSize = this.display.getPrimaryMonitor().getBounds();
        this.windowShell.setLocation((screenSize.width - this.windowShell.getBounds().width) / 2, (screenSize.height - this.windowShell.getBounds().height) / 2);
        this.windowShell.open();
        while (!this.windowShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.shellResult != 0;
    }

    private void migrateWorkspace(File oldDir, final File newDir) {
        this.progressLabel.setText("Counting workspace files...");
        int totalFiles = this.countWorkspaceFiles(oldDir);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(totalFiles);
        BaseProgressMonitor monitor = new BaseProgressMonitor(){
            int filesProcessed = 0;

            public void subTask(final String name) {
                DBeaverSettingsImporter.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DBeaverSettingsImporter.this.progressLabel.setText(name);
                    }
                });
            }

            public void worked(final int work) {
                DBeaverSettingsImporter.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        filesProcessed += work;
                        DBeaverSettingsImporter.this.progressBar.setSelection(filesProcessed);
                    }
                });
            }
        };
        new Thread((DBRProgressMonitor)monitor, oldDir){
            private final /* synthetic */ DBRProgressMonitor val$monitor;
            private final /* synthetic */ File val$oldDir;
            {
                this.val$monitor = dBRProgressMonitor;
                this.val$oldDir = file2;
            }

            @Override
            public void run() {
                block3: {
                    try {
                        if (newDir.exists() || newDir.mkdirs()) break block3;
                        System.err.println("Can't create target workspace directory '" + newDir.getAbsolutePath() + "'");
                        DBeaverApplication.WORKSPACE_MIGRATED = true;
                    }
                    catch (Throwable throwable) {
                        DBeaverApplication.WORKSPACE_MIGRATED = true;
                        DBeaverSettingsImporter.this.display.syncExec(new Runnable(newDir){
                            private final /* synthetic */ File val$newDir;
                            {
                                this.val$newDir = file;
                            }

                            @Override
                            public void run() {
                                DBeaverSettingsImporter.this.showMessageBox("Import completed", "Configuration was imported to '" + this.val$newDir.getAbsolutePath() + "'", 34);
                                DBeaverSettingsImporter.this.shellResult = 32;
                                DBeaverSettingsImporter.this.windowShell.dispose();
                            }
                        });
                        throw throwable;
                    }
                    DBeaverSettingsImporter.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                DBeaverSettingsImporter.this.copyWorkspaceFiles(this.val$monitor, DIR_TYPE.WORKSPACE, this.val$oldDir, newDir);
                DBeaverApplication.WORKSPACE_MIGRATED = true;
                DBeaverSettingsImporter.this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    private int countWorkspaceFiles(File dir) {
        int count = 1;
        File[] files = dir.listFiles();
        if (files == null) {
            return count;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            count = file.isDirectory() ? (count += this.countWorkspaceFiles(file)) : ++count;
            ++n2;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private void copyWorkspaceFiles(DBRProgressMonitor monitor, DIR_TYPE parentDirType, File fromDir, File toDir) {
        files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        skippedFiles = 0;
        var10_7 = files;
        var9_8 = files.length;
        var8_9 = 0;
        while (var8_9 < var9_8) {
            block87: {
                block85: {
                    block88: {
                        block86: {
                            file = var10_7[var8_9];
                            dirType = DIR_TYPE.NORMAL;
                            var12_12 = file.getName();
                            tmp = -1;
                            switch (var12_12.hashCode()) {
                                case -1988530851: {
                                    if (var12_12.equals(".metadata")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case -1910732878: {
                                    if (var12_12.equals(".plugins")) {
                                        tmp = 2;
                                    }
                                    break;
                                }
                                case 2089097844: {
                                    if (var12_12.equals("org.jkiss.dbeaver.core")) {
                                        tmp = 3;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    if (parentDirType != DIR_TYPE.WORKSPACE) break;
                                    dirType = DIR_TYPE.METADATA;
                                    break;
                                }
                                case 2: {
                                    if (parentDirType != DIR_TYPE.METADATA) break;
                                    dirType = DIR_TYPE.PLUGINS;
                                    break;
                                }
                                case 3: {
                                    if (parentDirType != DIR_TYPE.PLUGINS) break;
                                    dirType = DIR_TYPE.CORE;
                                }
                            }
                            relPath = file.getAbsolutePath().substring(this.oldWorkspacePath.getAbsolutePath().length());
                            monitor.subTask(relPath);
                            if (!file.isDirectory()) break block85;
                            if (parentDirType != DIR_TYPE.METADATA || file.getName().equals(".plugins")) break block86;
                            skippedFiles += this.countWorkspaceFiles(file);
                            break block87;
                        }
                        if (parentDirType != DIR_TYPE.PLUGINS || ArrayUtils.contains((Object[])DBeaverSettingsImporter.COPY_PLUGINS, (Object)file.getName())) break block88;
                        skippedFiles += this.countWorkspaceFiles(file);
                        break block87;
                    }
                    if (parentDirType != DIR_TYPE.CORE) ** GOTO lbl-1000
                    var14_14 = file.getName();
                    tmp = -1;
                    switch (var14_14.hashCode()) {
                        case -934610874: {
                            if (var14_14.equals("remote")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 103670155: {
                            if (var14_14.equals("maven")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 1920363851: {
                            if (var14_14.equals("drivers")) {
                                tmp = 1;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            targetDir = new File(this.driversFolder, file.getName());
                            if (!targetDir.exists() && !targetDir.mkdirs()) {
                                System.err.println("Can't create drivers folder " + targetDir.getAbsolutePath());
                                skippedFiles += this.countWorkspaceFiles(file);
                            } else {
                                this.copyWorkspaceFiles(monitor, DIR_TYPE.NORMAL, file, targetDir);
                            }
                            break block87;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if ((newDir = new File(toDir, file.getName())).exists() || newDir.mkdir()) {
                                this.copyWorkspaceFiles(monitor, dirType, file, newDir);
                                break;
                            }
                            System.err.println("Can't create folder " + newDir.getAbsolutePath());
                            break;
                        }
                    }
                    ** GOTO lbl197
                }
                if (parentDirType == DIR_TYPE.METADATA && file.getName().startsWith(".")) {
                    ++skippedFiles;
                } else {
                    newFile = new File(toDir, file.getName());
                    if (file.getName().equals("org.jkiss.dbeaver.core.prefs")) {
                        coreProps = new Properties();
                        try {
                            var16_16 = null;
                            var17_23 = null;
                            try {
                                is = new FileInputStream(file);
                                try {
                                    coreProps.load(is);
                                }
                                finally {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                            catch (Throwable var17_24) {
                                if (var16_16 == null) {
                                    var16_16 = var17_24;
                                } else if (var16_16 != var17_24) {
                                    var16_16.addSuppressed(var17_24);
                                }
                                throw var16_16;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        driversHomeProp = coreProps.getProperty("ui.drivers.home");
                        if (driversHomeProp != null && !driversHomeProp.isEmpty() && (oldDriversPath = new File((String)driversHomeProp)).equals(new File(this.oldWorkspacePath, ".metadata/.plugins/org.jkiss.dbeaver.core"))) {
                            coreProps.setProperty("ui.drivers.home", this.driversFolder.getAbsolutePath());
                        }
                        try {
                            oldDriversPath = null;
                            is = null;
                            try {
                                os = new FileOutputStream(newFile);
                                try {
                                    coreProps.store(os, null);
                                }
                                finally {
                                    if (os != null) {
                                        os.close();
                                    }
                                }
                            }
                            catch (Throwable is) {
                                if (oldDriversPath == null) {
                                    oldDriversPath = is;
                                } else if (oldDriversPath != is) {
                                    oldDriversPath.addSuppressed(is);
                                }
                                throw oldDriversPath;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    } else if (parentDirType == DIR_TYPE.CORE && file.getName().equals("drivers.xml")) {
                        driversText = null;
                        try {
                            driversHomeProp = null;
                            var17_23 = null;
                            try {
                                r = new InputStreamReader((InputStream)new FileInputStream(file), GeneralUtils.UTF8_CHARSET);
                                try {
                                    driversText = IOUtils.readToString((Reader)r);
                                    driversText = driversText.replace("${workspace}\\.metadata\\.plugins\\org.jkiss.dbeaver.core", "${drivers_home}");
                                    driversText = driversText.replace("${workspace}/.metadata/.plugins/org.jkiss.dbeaver.core", "${drivers_home}");
                                }
                                finally {
                                    if (r != null) {
                                        r.close();
                                    }
                                }
                            }
                            catch (Throwable var17_27) {
                                if (driversHomeProp == null) {
                                    driversHomeProp = var17_27;
                                } else if (driversHomeProp != var17_27) {
                                    driversHomeProp.addSuppressed(var17_27);
                                }
                                throw driversHomeProp;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        if (driversText != null) {
                            try {
                                e = null;
                                var17_23 = null;
                                try {
                                    w = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), GeneralUtils.UTF8_CHARSET);
                                    try {
                                        w.write(driversText);
                                    }
                                    finally {
                                        if (w != null) {
                                            w.close();
                                        }
                                    }
                                }
                                catch (Throwable var17_28) {
                                    if (e == null) {
                                        e = var17_28;
                                    } else if (e != var17_28) {
                                        e.addSuppressed(var17_28);
                                    }
                                    throw e;
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    } else {
                        this.copyFileContents(file, newFile);
                    }
                    monitor.worked(1 + skippedFiles);
                }
            }
            ++var8_9;
        }
    }

    private void copyFileContents(File file, File newFile) {
        if (!newFile.exists() || newFile.length() != file.length()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (FileOutputStream os = new FileOutputStream(newFile);){
                        IOUtils.fastCopy((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    int showMessageBox(String title, String message, int style) {
        MessageBox messageBox = new MessageBox(this.windowShell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    static enum DIR_TYPE {
        WORKSPACE,
        NORMAL,
        METADATA,
        PLUGINS,
        CORE;

    }
}

