/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DatabaseMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    private static final Log log = Log.getLog(DatabaseMarkerAnnotationModel.class);
    private static final String[] ATTRIBUTE_NAMES = new String[]{"org.jkiss.dbeaver.runtime.marker.datasourceId", "org.jkiss.dbeaver.runtime.marker.nodePath"};
    private final DBSObject databaseObject;
    private final DBNNode node;
    private final String datasourceId;
    private final String nodeItemPath;

    public DatabaseMarkerAnnotationModel(DBSObject databaseObject, DBNDatabaseNode node, IResource resource) {
        super(resource);
        this.databaseObject = databaseObject;
        this.node = node;
        this.datasourceId = databaseObject.getDataSource().getContainer().getId();
        this.nodeItemPath = node.getNodeItemPath();
    }

    protected DBSObject getDatabaseObject() {
        return this.databaseObject;
    }

    protected DBNNode getNode() {
        return this.node;
    }

    protected boolean isAcceptable(IMarker marker) {
        boolean acceptable = super.isAcceptable(marker);
        if (!acceptable) {
            return false;
        }
        try {
            Object[] attributes = marker.getAttributes(ATTRIBUTE_NAMES);
            return this.datasourceId.equals(attributes[0]) && this.nodeItemPath.equals(attributes[1]);
        }
        catch (CoreException e) {
            log.log(e.getStatus());
            return false;
        }
    }
}

