/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Erasure;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Canonicalize {
    private final SourceFile source;
    private final int position;
    private final Env<ClassSymbol, TypeBoundClass> env;

    public static Type canonicalize(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Type type) {
        return new Canonicalize(source, position, env).canonicalize(sym, type);
    }

    public static Type.ClassTy canonicalizeClassTy(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol owner, Type.ClassTy classTy) {
        return new Canonicalize(source, position, env).canonicalizeClassTy(owner, classTy);
    }

    public Canonicalize(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env) {
        this.source = source;
        this.position = position;
        this.env = env;
    }

    private Type canonicalize(ClassSymbol base, Type type) {
        switch (type.tyKind()) {
            case PRIM_TY: 
            case VOID_TY: 
            case TY_VAR: {
                return type;
            }
            case WILD_TY: {
                return this.canonicalizeWildTy(base, (Type.WildTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                return new Type.ArrayTy(this.canonicalize(base, arrayTy.elementType()), arrayTy.annos());
            }
            case CLASS_TY: {
                return this.canonicalizeClassTy(base, (Type.ClassTy)type);
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private Type.ClassTy canon(ClassSymbol base, Type.ClassTy ty) {
        Type.ClassTy canon;
        if (this.isRaw(ty)) {
            return Erasure.eraseClassTy(ty);
        }
        UnmodifiableIterator it = ty.classes.iterator();
        Collection<Type.ClassTy.SimpleClassTy> lexicalBase = this.lexicalBase(((Type.ClassTy.SimpleClassTy)ty.classes.get(0)).sym(), base);
        Type.ClassTy classTy = canon = !lexicalBase.isEmpty() ? new Type.ClassTy(lexicalBase) : new Type.ClassTy(Collections.singletonList(it.next()));
        while (it.hasNext()) {
            canon = this.canonOne(canon, (Type.ClassTy.SimpleClassTy)it.next());
        }
        return canon;
    }

    private boolean isRaw(Type.ClassTy ty) {
        for (Type.ClassTy.SimpleClassTy s : ty.classes.reverse()) {
            TypeBoundClass info = this.getInfo(s.sym());
            if (s.targs().isEmpty() && !info.typeParameters().isEmpty()) {
                return true;
            }
            if ((info.access() & 8) != 8) continue;
            break;
        }
        return false;
    }

    private Collection<Type.ClassTy.SimpleClassTy> lexicalBase(ClassSymbol first, ClassSymbol owner) {
        if ((this.getInfo(first).access() & 8) == 8) {
            return Collections.emptyList();
        }
        ClassSymbol canonOwner = this.getInfo(first).owner();
        ArrayDeque<Type.ClassTy.SimpleClassTy> result = new ArrayDeque<Type.ClassTy.SimpleClassTy>();
        while (canonOwner != null && owner != null) {
            if (!this.isSubclass(owner, canonOwner)) {
                owner = this.getInfo(owner).owner();
                continue;
            }
            result.addFirst(this.uninstantiated(owner));
            if ((this.getInfo(owner).access() & 8) == 8) break;
            canonOwner = this.getInfo(canonOwner).owner();
        }
        return result;
    }

    private Type.ClassTy.SimpleClassTy uninstantiated(ClassSymbol owner) {
        ImmutableList.Builder targs = ImmutableList.builder();
        for (TyVarSymbol p : this.getInfo(owner).typeParameterTypes().keySet()) {
            targs.add((Object)new Type.TyVar(p, (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }
        return new Type.ClassTy.SimpleClassTy(owner, (ImmutableList<Type>)targs.build(), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    private boolean isSubclass(ClassSymbol s, ClassSymbol t) {
        while (s != null) {
            if (s.equals(t)) {
                return true;
            }
            s = this.getInfo(s).superclass();
        }
        return false;
    }

    private Type.ClassTy canonOne(Type.ClassTy base, Type.ClassTy.SimpleClassTy ty) {
        if ((this.getInfo(ty.sym()).access() & 8) == 8) {
            return new Type.ClassTy(Collections.singletonList(ty));
        }
        ImmutableList.Builder simples = ImmutableList.builder();
        ClassSymbol owner = this.getInfo(ty.sym()).owner();
        if (owner.equals(base.sym())) {
            simples.addAll(base.classes);
            simples.add((Object)ty);
            return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
        }
        Type.ClassTy curr = base;
        LinkedHashMap<TyVarSymbol, Type> mapping = new LinkedHashMap<TyVarSymbol, Type>();
        while (curr != null) {
            for (Type.ClassTy.SimpleClassTy s : curr.classes) {
                this.addInstantiation(mapping, s);
            }
            if (curr.sym().equals(owner)) {
                for (Type.ClassTy.SimpleClassTy s : curr.classes) {
                    simples.add((Object)this.instantiate(mapping, s.sym()));
                }
                break;
            }
            TypeBoundClass info = this.getInfo(curr.sym());
            curr = this.canon(info.owner(), info.superClassType());
        }
        simples.add((Object)ty);
        return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
    }

    private void addInstantiation(Map<TyVarSymbol, Type> mapping, Type.ClassTy.SimpleClassTy simpleType) {
        ImmutableCollection symbols = this.getInfo(simpleType.sym()).typeParameters().values();
        if (simpleType.targs().isEmpty()) {
            for (TyVarSymbol sym : symbols) {
                mapping.put(sym, null);
            }
            return;
        }
        Verify.verify((symbols.size() == simpleType.targs().size() ? 1 : 0) != 0);
        UnmodifiableIterator typeArguments = simpleType.targs().iterator();
        for (TyVarSymbol sym : symbols) {
            Type argument = (Type)typeArguments.next();
            if (Objects.equals(this.tyVarSym(argument), sym)) continue;
            mapping.put(sym, argument);
        }
    }

    private Type.ClassTy.SimpleClassTy instantiate(Map<TyVarSymbol, Type> mapping, ClassSymbol classSymbol) {
        ArrayList<Type> args = new ArrayList<Type>();
        for (TyVarSymbol sym : this.getInfo(classSymbol).typeParameterTypes().keySet()) {
            if (!mapping.containsKey(sym)) {
                args.add(new Type.TyVar(sym, (ImmutableList<AnnoInfo>)ImmutableList.of()));
                continue;
            }
            Type arg = this.instantiate(mapping, mapping.get(sym));
            if (arg == null) {
                args.clear();
                break;
            }
            args.add(arg);
        }
        return new Type.ClassTy.SimpleClassTy(classSymbol, (ImmutableList<Type>)ImmutableList.copyOf(args), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    private Type instantiate(Map<TyVarSymbol, Type> mapping, Type type) {
        if (type == null) {
            return null;
        }
        switch (type.tyKind()) {
            case WILD_TY: {
                return this.instantiateWildTy(mapping, (Type.WildTy)type);
            }
            case PRIM_TY: 
            case VOID_TY: {
                return type;
            }
            case CLASS_TY: {
                return this.instantiateClassTy(mapping, (Type.ClassTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                Type elem = this.instantiate(mapping, arrayTy.elementType());
                return new Type.ArrayTy(elem, arrayTy.annos());
            }
            case TY_VAR: {
                Type.TyVar tyVar = (Type.TyVar)type;
                if (mapping.containsKey(tyVar.sym())) {
                    return this.instantiate(mapping, mapping.get(tyVar.sym()));
                }
                return type;
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private Type instantiateWildTy(Map<TyVarSymbol, Type> mapping, Type.WildTy type) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case UPPER: {
                return new Type.WildUpperBoundedTy(this.instantiate(mapping, type.bound()), type.annotations());
            }
            case LOWER: {
                return new Type.WildLowerBoundedTy(this.instantiate(mapping, type.bound()), type.annotations());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }

    private Type instantiateClassTy(Map<TyVarSymbol, Type> mapping, Type.ClassTy type) {
        ImmutableList.Builder simples = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy simple : type.classes) {
            ImmutableList.Builder args = ImmutableList.builder();
            for (Type arg : simple.targs()) {
                args.add((Object)this.instantiate(mapping, arg));
            }
            simples.add((Object)new Type.ClassTy.SimpleClassTy(simple.sym(), (ImmutableList<Type>)args.build(), simple.annos()));
        }
        return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
    }

    private @Nullable TyVarSymbol tyVarSym(Type type) {
        if (type.tyKind() == Type.TyKind.TY_VAR) {
            return ((Type.TyVar)type).sym();
        }
        return null;
    }

    private Type.ClassTy canonicalizeClassTy(ClassSymbol base, Type.ClassTy ty) {
        ImmutableList.Builder args = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy s : ty.classes) {
            args.add((Object)new Type.ClassTy.SimpleClassTy(s.sym(), this.canonicalize(s.targs(), base, this.env), s.annos()));
        }
        ty = new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)args.build());
        return this.canon(base, ty);
    }

    private ImmutableList<Type> canonicalize(ImmutableList<Type> targs, ClassSymbol base, Env<ClassSymbol, TypeBoundClass> env) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type a : targs) {
            result.add((Object)this.canonicalize(base, a));
        }
        return result.build();
    }

    private Type canonicalizeWildTy(ClassSymbol base, Type.WildTy type) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case LOWER: {
                return new Type.WildLowerBoundedTy(this.canonicalize(base, type.bound()), type.annotations());
            }
            case UPPER: {
                return new Type.WildUpperBoundedTy(this.canonicalize(base, type.bound()), type.annotations());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }

    private TypeBoundClass getInfo(ClassSymbol canonOwner) {
        TypeBoundClass info = this.env.get(canonOwner);
        if (info == null) {
            throw TurbineError.format(this.source, this.position, TurbineError.ErrorKind.CLASS_FILE_NOT_FOUND, canonOwner);
        }
        return info;
    }
}

