/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Return
extends AbstractNode
implements Statement {
    private AbstractNode value = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astValue() {
        if (!(this.value instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.value);
    }

    public Return astValue(Expression value) {
        return this.rawValue(value);
    }

    public Node rawValue() {
        return this.value;
    }

    public Return rawValue(Node value) {
        if (value == this.value) {
            return this;
        }
        if (value != null) {
            this.adopt((AbstractNode)value);
        }
        if (this.value != null) {
            this.disown(this.value);
        }
        this.value = (AbstractNode)value;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.value != null) {
            result.add(this.value);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.value == original) {
            this.rawValue(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.value == child) {
            this.disown((AbstractNode)child);
            this.value = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitReturn(this)) {
            return;
        }
        if (this.value != null) {
            this.value.accept(visitor);
        }
        visitor.afterVisitReturn(this);
        visitor.endVisit(this);
    }

    @Override
    public Return copy() {
        Return result = new Return();
        if (this.value != null) {
            result.rawValue(this.value.copy());
        }
        return result;
    }
}

