/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.local.LocalSdk;
import java.io.File;
import java.util.Properties;

public abstract class LocalPkgInfo
implements Comparable<LocalPkgInfo> {
    private final LocalSdk mLocalSdk;
    private final File mLocalDir;
    private final Properties mSourceProperties;
    private String mLoadError;

    protected LocalPkgInfo(LocalSdk localSdk, File localDir, Properties sourceProps) {
        this.mLocalSdk = localSdk;
        this.mLocalDir = localDir;
        this.mSourceProperties = sourceProps;
    }

    public LocalSdk getLocalSdk() {
        return this.mLocalSdk;
    }

    public File getLocalDir() {
        return this.mLocalDir;
    }

    public Properties getSourceProperties() {
        return this.mSourceProperties;
    }

    public String getLoadError() {
        return this.mLoadError;
    }

    public abstract IPkgDesc getDesc();

    @Override
    public int compareTo(LocalPkgInfo o) {
        return this.getDesc().compareTo(o.getDesc());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(this.getClass().getSimpleName()).append(' ');
        builder.append(this.getDesc().toString());
        builder.append('>');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDesc() == null ? 0 : this.getDesc().hashCode());
        result = 31 * result + (this.mLocalDir == null ? 0 : this.mLocalDir.hashCode());
        result = 31 * result + (this.mSourceProperties == null ? 0 : this.mSourceProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalPkgInfo)) {
            return false;
        }
        LocalPkgInfo other = (LocalPkgInfo)obj;
        if (!this.getDesc().equals(other.getDesc())) {
            return false;
        }
        if (this.mLocalDir == null ? other.mLocalDir != null : !this.mLocalDir.equals(other.mLocalDir)) {
            return false;
        }
        return !(this.mSourceProperties == null ? other.mSourceProperties != null : !this.mSourceProperties.equals(other.mSourceProperties));
    }

    void appendLoadError(String format, Object ... params) {
        String loadError = String.format(format, params);
        this.mLoadError = this.mLoadError == null ? loadError : this.mLoadError + '\n' + loadError;
    }

    public String getListDescription() {
        return this.getDesc().getListDescription();
    }

    public void delete() {
        FileOpUtils.create().deleteFileOrFolder(this.getLocalDir());
    }
}

