//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 **/
public interface LocatorPrx extends ObjectPrx
{
    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @return The proxy, or null if the object is not active.
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     **/
    default ObjectPrx findObjectById(Identity id)
        throws ObjectNotFoundException
    {
        return findObjectById(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy, or null if the object is not active.
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     **/
    default ObjectPrx findObjectById(Identity id, java.util.Map<String, String> context)
        throws ObjectNotFoundException
    {
        try
        {
            return _iceI_findObjectByIdAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(ObjectNotFoundException ex)
        {
            throw ex;
        }
        catch(UserException ex)
        {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @return The proxy, or null if the object is not active.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByIdAsync(Identity id)
    {
        return _iceI_findObjectByIdAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy, or null if the object is not active.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findObjectByIdAsync(Identity id, java.util.Map<String, String> context)
    {
        return _iceI_findObjectByIdAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_findObjectByIdAsync(Identity iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findObjectById", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_findObjectById);
        f.invoke(true, context, null, ostr -> {
                     Identity.ice_write(ostr, iceP_id);
                 }, istr -> {
                     ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_findObjectById =
    {
        ObjectNotFoundException.class
    };

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @return The adapter proxy, or null if the adapter is not active.
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     **/
    default ObjectPrx findAdapterById(String id)
        throws AdapterNotFoundException
    {
        return findAdapterById(id, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     **/
    default ObjectPrx findAdapterById(String id, java.util.Map<String, String> context)
        throws AdapterNotFoundException
    {
        try
        {
            return _iceI_findAdapterByIdAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch(AdapterNotFoundException ex)
        {
            throw ex;
        }
        catch(UserException ex)
        {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @return The adapter proxy, or null if the adapter is not active.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findAdapterByIdAsync(String id)
    {
        return _iceI_findAdapterByIdAsync(id, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> findAdapterByIdAsync(String id, java.util.Map<String, String> context)
    {
        return _iceI_findAdapterByIdAsync(id, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_findAdapterByIdAsync(String iceP_id, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "findAdapterById", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_findAdapterById);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                 }, istr -> {
                     ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_findAdapterById =
    {
        AdapterNotFoundException.class
    };

    /**
     * Get the locator registry.
     * @return The locator registry.
     **/
    default LocatorRegistryPrx getRegistry()
    {
        return getRegistry(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @return The locator registry.
     **/
    default LocatorRegistryPrx getRegistry(java.util.Map<String, String> context)
    {
        return _iceI_getRegistryAsync(context, true).waitForResponse();
    }

    /**
     * Get the locator registry.
     * @return The locator registry.
     **/
    default java.util.concurrent.CompletableFuture<LocatorRegistryPrx> getRegistryAsync()
    {
        return _iceI_getRegistryAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @return The locator registry.
     **/
    default java.util.concurrent.CompletableFuture<LocatorRegistryPrx> getRegistryAsync(java.util.Map<String, String> context)
    {
        return _iceI_getRegistryAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<LocatorRegistryPrx> _iceI_getRegistryAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<LocatorRegistryPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getRegistry", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     LocatorRegistryPrx ret;
                     ret = LocatorRegistryPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LocatorPrx checkedCast(ObjectPrx obj)
    {
        return ObjectPrx._checkedCast(obj, ice_staticId(), LocatorPrx.class, _LocatorPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LocatorPrx checkedCast(ObjectPrx obj, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, context, ice_staticId(), LocatorPrx.class, _LocatorPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LocatorPrx checkedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._checkedCast(obj, facet, ice_staticId(), LocatorPrx.class, _LocatorPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static LocatorPrx checkedCast(ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), LocatorPrx.class, _LocatorPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static LocatorPrx uncheckedCast(ObjectPrx obj)
    {
        return ObjectPrx._uncheckedCast(obj, LocatorPrx.class, _LocatorPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static LocatorPrx uncheckedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._uncheckedCast(obj, facet, LocatorPrx.class, _LocatorPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default LocatorPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (LocatorPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default LocatorPrx ice_adapterId(String newAdapterId)
    {
        return (LocatorPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default LocatorPrx ice_endpoints(Endpoint[] newEndpoints)
    {
        return (LocatorPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default LocatorPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (LocatorPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default LocatorPrx ice_invocationTimeout(int newTimeout)
    {
        return (LocatorPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default LocatorPrx ice_connectionCached(boolean newCache)
    {
        return (LocatorPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default LocatorPrx ice_endpointSelection(EndpointSelectionType newType)
    {
        return (LocatorPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default LocatorPrx ice_secure(boolean b)
    {
        return (LocatorPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default LocatorPrx ice_encodingVersion(EncodingVersion e)
    {
        return (LocatorPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default LocatorPrx ice_preferSecure(boolean b)
    {
        return (LocatorPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default LocatorPrx ice_router(RouterPrx router)
    {
        return (LocatorPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default LocatorPrx ice_locator(LocatorPrx locator)
    {
        return (LocatorPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default LocatorPrx ice_collocationOptimized(boolean b)
    {
        return (LocatorPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default LocatorPrx ice_twoway()
    {
        return (LocatorPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default LocatorPrx ice_oneway()
    {
        return (LocatorPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default LocatorPrx ice_batchOneway()
    {
        return (LocatorPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default LocatorPrx ice_datagram()
    {
        return (LocatorPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default LocatorPrx ice_batchDatagram()
    {
        return (LocatorPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default LocatorPrx ice_compress(boolean co)
    {
        return (LocatorPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default LocatorPrx ice_timeout(int t)
    {
        return (LocatorPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default LocatorPrx ice_connectionId(String connectionId)
    {
        return (LocatorPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default LocatorPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (LocatorPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Ice::Locator";
    }
}
