/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;

public class YouTrackIntellisense {
    public static final Key<YouTrackIntellisense> INTELLISENSE_KEY = Key.create((String)"youtrack.intellisense");
    private static final Logger LOG = Logger.getInstance(YouTrackIntellisense.class);
    public static final String INTELLISENSE_RESOURCE = "/rest/issue/intellisense";
    private static final Map<String, TextAttributes> TEXT_ATTRIBUTES = ContainerUtil.newHashMap((Pair)Pair.create((Object)"field", (Object)DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes()), (Pair[])new Pair[]{Pair.create((Object)"keyword", (Object)DefaultLanguageHighlighterColors.KEYWORD.getDefaultAttributes()), Pair.create((Object)"string", (Object)DefaultLanguageHighlighterColors.STRING.getDefaultAttributes()), Pair.create((Object)"error", (Object)HighlighterColors.BAD_CHARACTER.getDefaultAttributes())});
    private static final int CACHE_SIZE = 30;
    private static final Map<Pair<String, Integer>, Response> ourCache = Collections.synchronizedMap(new SizeLimitedCache(30));
    private final YouTrackRepository myRepository;

    @NotNull
    private static TextAttributes getAttributeByStyleClass(@NotNull String styleClass) {
        TextAttributes attr;
        if (styleClass == null) {
            YouTrackIntellisense.$$$reportNull$$$0(0);
        }
        TextAttributes textAttributes = (attr = TEXT_ATTRIBUTES.get(styleClass)) == null ? HighlighterColors.TEXT.getDefaultAttributes() : attr;
        if (textAttributes == null) {
            YouTrackIntellisense.$$$reportNull$$$0(1);
        }
        return textAttributes;
    }

    @NotNull
    public List<HighlightRange> fetchHighlighting(@NotNull String query, int caret) throws Exception {
        if (query == null) {
            YouTrackIntellisense.$$$reportNull$$$0(2);
        }
        LOG.debug("Requesting highlighting");
        List<HighlightRange> list = this.fetch(query, caret, true).getHighlightRanges();
        if (list == null) {
            YouTrackIntellisense.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<CompletionItem> fetchCompletion(@NotNull String query, int caret) throws Exception {
        if (query == null) {
            YouTrackIntellisense.$$$reportNull$$$0(4);
        }
        LOG.debug("Requesting completion");
        List<CompletionItem> list = this.fetch(query, caret, false).getCompletionItems();
        if (list == null) {
            YouTrackIntellisense.$$$reportNull$$$0(5);
        }
        return list;
    }

    public YouTrackIntellisense(@NotNull YouTrackRepository repository) {
        if (repository == null) {
            YouTrackIntellisense.$$$reportNull$$$0(6);
        }
        this.myRepository = repository;
    }

    @NotNull
    private Response fetch(@NotNull String query, int caret, boolean ignoreCaret) throws Exception {
        if (query == null) {
            YouTrackIntellisense.$$$reportNull$$$0(7);
        }
        LOG.debug("Query: '" + query + "' caret at: " + caret);
        Pair lookup = Pair.create((Object)query, (Object)caret);
        Response response = null;
        if (ignoreCaret) {
            for (Pair<String, Integer> pair : ourCache.keySet()) {
                if (!((String)pair.getFirst()).equals(query)) continue;
                response = ourCache.get(pair);
                break;
            }
        } else {
            response = ourCache.get(lookup);
        }
        LOG.debug("Cache " + (response != null ? "hit" : "miss"));
        if (response == null) {
            String url = String.format("%s?filter=%s&caret=%d", INTELLISENSE_RESOURCE, URLEncoder.encode(query, "utf-8"), caret);
            long startTime = System.currentTimeMillis();
            response = new Response(this.myRepository.doREST(url, false).getResponseBodyAsStream());
            LOG.debug(String.format("Intellisense request to YouTrack took %d ms to complete", System.currentTimeMillis() - startTime));
            ourCache.put((Pair<String, Integer>)lookup, response);
        }
        Response response2 = response;
        if (response2 == null) {
            YouTrackIntellisense.$$$reportNull$$$0(8);
        }
        return response2;
    }

    public YouTrackRepository getRepository() {
        return this.myRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackIntellisense";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeByStyleClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchHighlighting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCompletion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeByStyleClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchHighlighting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchCompletion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CompletionItem {
        private final TextRange myMatchRange;
        private final TextRange myCompletionRange;
        private final int myCaretPosition;
        private final String myDescription;
        private final String mySuffix;
        private final String myPrefix;
        private final String myOption;
        private final String myStyleClass;

        public CompletionItem(@NotNull Element item) {
            if (item == null) {
                CompletionItem.$$$reportNull$$$0(0);
            }
            Element match = item.getChild("match");
            this.myMatchRange = new TextRange(Integer.parseInt(match.getAttributeValue("start")), Integer.parseInt(match.getAttributeValue("end")));
            Element completion = item.getChild("completion");
            this.myCompletionRange = new TextRange(Integer.parseInt(completion.getAttributeValue("start")), Integer.parseInt(completion.getAttributeValue("end")));
            this.myDescription = item.getChildText("description");
            this.myOption = item.getChildText("option");
            this.mySuffix = item.getChildText("suffix");
            this.myPrefix = item.getChildText("prefix");
            this.myStyleClass = item.getChildText("styleClass");
            this.myCaretPosition = Integer.valueOf(item.getChildText("caret"));
        }

        @NotNull
        public TextRange getMatchRange() {
            TextRange textRange = this.myMatchRange;
            if (textRange == null) {
                CompletionItem.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @NotNull
        public TextRange getCompletionRange() {
            TextRange textRange = this.myCompletionRange;
            if (textRange == null) {
                CompletionItem.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        public int getCaretPosition() {
            return this.myCaretPosition;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getSuffix() {
            String string = StringUtil.notNullize((String)this.mySuffix);
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getPrefix() {
            String string = StringUtil.notNullize((String)this.myPrefix);
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getOption() {
            String string = this.myOption;
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getStyleClass() {
            String string = StringUtil.notNullize((String)this.myStyleClass);
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        TextAttributes getTextAttributes() {
            TextAttributes textAttributes = YouTrackIntellisense.getAttributeByStyleClass(this.myStyleClass);
            if (textAttributes == null) {
                CompletionItem.$$$reportNull$$$0(8);
            }
            return textAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatchRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOption";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyleClass";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HighlightRange {
        private final int myStart;
        private final int myEnd;
        private final String myStyleClass;

        public HighlightRange(@NotNull Element rangeElement) {
            if (rangeElement == null) {
                HighlightRange.$$$reportNull$$$0(0);
            }
            this.myStart = Integer.valueOf(rangeElement.getChildText("start"));
            this.myEnd = Integer.valueOf(rangeElement.getChildText("end"));
            this.myStyleClass = rangeElement.getChildText("styleClass");
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        @NotNull
        public String getStyleClass() {
            String string = StringUtil.notNullize((String)this.myStyleClass);
            if (string == null) {
                HighlightRange.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = new TextRange(this.myStart, this.myEnd);
            if (textRange == null) {
                HighlightRange.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.create((int)this.myStart, (int)this.myEnd);
            if (textRange == null) {
                HighlightRange.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            TextAttributes textAttributes = YouTrackIntellisense.getAttributeByStyleClass(this.myStyleClass);
            if (textAttributes == null) {
                HighlightRange.$$$reportNull$$$0(4);
            }
            return textAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyleClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Response {
        private final List<HighlightRange> myHighlightRanges;
        private final List<CompletionItem> myCompletionItems;

        public Response(@NotNull InputStream stream) throws Exception {
            if (stream == null) {
                Response.$$$reportNull$$$0(0);
            }
            Element root = new SAXBuilder().build(stream).getRootElement();
            TaskUtil.prettyFormatXmlToLog((Logger)LOG, (Element)root);
            Element highlight = root.getChild("highlight");
            this.myHighlightRanges = ContainerUtil.map((Collection)highlight.getChildren("range"), range -> new HighlightRange((Element)range));
            Element suggest = root.getChild("suggest");
            this.myCompletionItems = ContainerUtil.map((Collection)suggest.getChildren("item"), item -> new CompletionItem((Element)item));
        }

        @NotNull
        public List<HighlightRange> getHighlightRanges() {
            List<HighlightRange> list = this.myHighlightRanges;
            if (list == null) {
                Response.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<CompletionItem> getCompletionItems() {
            List<CompletionItem> list = this.myCompletionItems;
            if (list == null) {
                Response.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense$Response";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackIntellisense$Response";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightRanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SizeLimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int myMaxSize;

        private SizeLimitedCache(int max) {
            super((int)((double)max / 0.75) + 1, true);
            this.myMaxSize = max;
        }

        protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
            return this.size() > this.myMaxSize;
        }
    }
}

