/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLPlainTextImpl
extends YAMLScalarImpl
implements YAMLScalar {
    public YAMLPlainTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        int myStart = this.getTextRange().getStartOffset();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        boolean seenText = false;
        for (ASTNode child = this.getFirstContentNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == YAMLTokenTypes.TEXT) {
                seenText = true;
                result.add(child.getTextRange().shiftRight(-myStart));
                continue;
            }
            if (child.getElementType() != YAMLTokenTypes.EOL) continue;
            if (!seenText) {
                result.add(child.getTextRange().shiftRight(-myStart));
            }
            seenText = false;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        if (text == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(2);
        }
        if (contentRanges == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(3);
        }
        if (YAMLPlainTextImpl.isNewline(text, contentRanges.get(indexBefore)) || YAMLPlainTextImpl.isNewline(text, contentRanges.get(indexBefore + 1))) {
            if ("" == null) {
                YAMLPlainTextImpl.$$$reportNull$$$0(4);
            }
            return "";
        }
        if (" " == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(5);
        }
        return " ";
    }

    private static boolean isNewline(@NotNull CharSequence text, @NotNull TextRange range) {
        if (text == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(6);
        }
        if (range == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(7);
        }
        return range.getLength() == 1 && text.charAt(range.getStartOffset()) == '\n';
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(8);
        }
        YAMLPlainTextImpl.checkForConsistency(input);
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n\n" + indentString)));
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && input.charAt(i) == ' ' && YAMLPlainTextImpl.isSurroundedByNoSpace(input, i)) {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
                currentLength = 0;
                continue;
            }
            ++currentLength;
        }
        return result;
    }

    private static void checkForConsistency(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(9);
        }
        if (input.length() == 0) {
            throw new IllegalArgumentException("Cannot be empty");
        }
        if (!YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(0)) || !YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(input.length() - 1))) {
            throw new IllegalArgumentException("Cannot have leading or trailing whitespaces");
        }
        char firstChar = input.charAt(0);
        if ((firstChar != '?' && firstChar != ':' && firstChar != '-' || input.length() <= 1 || !YAMLGrammarCharUtil.isPlainSafe(input.charAt(1))) && YAMLGrammarCharUtil.isIndicatorChar(firstChar)) {
            throw new IllegalArgumentException("Could not start with indicator chars");
        }
        for (int i = 1; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n' && !YAMLPlainTextImpl.isSurroundedByNoSpace(input, i)) {
                throw new IllegalArgumentException("Could not form line with leading/trailing whitespace");
            }
            if (YAMLGrammarCharUtil.isSpaceLike(c) || YAMLGrammarCharUtil.isPlainSafe(c) && c != ':' && c != '#' || c == '#' && YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(i - 1)) || c == ':' && i + 1 < input.length() && YAMLGrammarCharUtil.isPlainSafe(input.charAt(i + 1))) continue;
            throw new IllegalArgumentException("Restricted characters appeared");
        }
    }

    @Override
    public String toString() {
        return "YAML plain scalar text";
    }

    @Override
    public boolean isMultiline() {
        return this.getNode().findChildByType((IElementType)YAMLTokenTypes.EOL) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRanges";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesJoiner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRangesJoiner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNewline";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkForConsistency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

