/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Rectangle;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessorBindingWrapper
extends Binding
implements MultiNodeBinding {
    protected final Binding myBinding;
    private final boolean myFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean flat, Property.Style beanStyle) {
        if (accessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(0);
        }
        if (binding == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(1);
        }
        super(accessor);
        this.myBinding = binding;
        this.myFlat = flat;
        this.beanStyle = beanStyle;
    }

    public boolean isFlat() {
        return this.myFlat;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value;
        if (o == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(2);
        }
        if ((value = this.myAccessor.read(o)) == null) {
            throw new XmlSerializationException("Property " + this.myAccessor + " of object " + o + " (" + o.getClass() + ") must not be null");
        }
        if (this.myFlat) {
            Element element = (Element)context;
            if (this.beanStyle == Property.Style.ATTRIBUTE && value instanceof Rectangle) {
                Rectangle bounds = (Rectangle)value;
                LOG.assertTrue(element != null);
                element.setAttribute("x", Integer.toString(bounds.x));
                element.setAttribute("y", Integer.toString(bounds.y));
                element.setAttribute("width", Integer.toString(bounds.width));
                element.setAttribute("height", Integer.toString(bounds.height));
            } else {
                ((BeanBinding)this.myBinding).serializeInto(value, element, filter);
            }
            return null;
        }
        return this.myBinding.serialize(value, context, filter);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(3);
        }
        return this.deserialize(context, element);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        if (context == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(4);
        }
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(5);
        }
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, element);
        } else {
            Object deserializedValue;
            block10: {
                if (this.beanStyle == Property.Style.ATTRIBUTE && this.myBinding instanceof BeanBinding && ((BeanBinding)this.myBinding).myBeanClass == Rectangle.class) {
                    String xA = element.getAttributeValue("x");
                    String yA = element.getAttributeValue("y");
                    String wA = element.getAttributeValue("width");
                    String hA = element.getAttributeValue("height");
                    if (xA != null && yA != null && wA != null && hA != null) {
                        int x = StringUtilRt.parseInt(xA, 0);
                        int y = StringUtilRt.parseInt(yA, 0);
                        int h = StringUtilRt.parseInt(hA, 0);
                        int w = StringUtilRt.parseInt(wA, 0);
                        deserializedValue = new Rectangle(x, y, w, h);
                        break block10;
                    } else {
                        Object object = context;
                        if (object == null) {
                            AccessorBindingWrapper.$$$reportNull$$$0(6);
                        }
                        return object;
                    }
                }
                deserializedValue = this.myBinding.deserializeUnsafe(currentValue, element);
            }
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        Object object = context;
        if (object == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(7);
        }
        return object;
    }

    @Override
    @Nullable
    public Object deserializeList(@NotNull Object context, @NotNull List<? extends Element> elements) {
        if (context == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(9);
        }
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList(this.myBinding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(10);
        }
        if (this.myBinding instanceof MapBinding) {
            return ((MapBinding)this.myBinding).isBoundToWithoutProperty(element);
        }
        return this.myBinding.isBoundTo(element);
    }

    public String toString() {
        return this.myBinding.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

