/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Module myModule;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private final Set<Module> myModules;

    ModuleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        this.myModules = ModuleWithDependentsScope.buildDependents(this.myModule);
    }

    @NotNull
    private static Set<Module> buildDependents(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(1);
        }
        THashSet result2 = new THashSet();
        result2.add(module);
        ModuleIndex index = ModuleWithDependentsScope.getModuleIndex(module.getProject());
        HashSetQueue walkingQueue = new HashSetQueue();
        walkingQueue.add((Object)module);
        for (Module current : walkingQueue) {
            result2.addAll(index.plainUsages.get((Object)current));
            Collection exported = index.exportingUsages.get((Object)current);
            walkingQueue.addAll(exported);
            result2.addAll(exported);
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(2);
        }
        return tHashSet;
    }

    @NotNull
    private static ModuleIndex getModuleIndex(@NotNull Project project) {
        if (project == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(3);
        }
        ModuleIndex moduleIndex = (ModuleIndex)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ModuleIndex index = new ModuleIndex();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    MultiMap<Module, Module> map = ((ModuleOrderEntry)orderEntry).isExported() ? index.exportingUsages : index.plainUsages;
                    map.putValue((Object)referenced, (Object)module);
                }
            }
            return CachedValueProvider.Result.create((Object)index, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
        if (moduleIndex == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(4);
        }
        return moduleIndex;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(5);
        }
        return this.contains(file2, false);
    }

    boolean contains(@NotNull VirtualFile file2, boolean myOnlyTests) {
        DirectoryInfo info;
        Module moduleOfFile;
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(6);
        }
        if ((moduleOfFile = (info = this.myProjectFileIndex.getInfoForFileOrDirectory(file2)).getModule()) == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (myOnlyTests && !TestSourcesFilter.isTestSources((VirtualFile)file2, (Project)moduleOfFile.getProject())) {
            return false;
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    public boolean isSearchInModuleContent(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(7);
        }
        return this.myModules.contains(module);
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.myModule.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        List list2 = ContainerUtil.mapNotNull(DirectoryIndex.getInstance(project).getDependentUnloadedModules(this.myModule), arg_0 -> ((ModuleManager)moduleManager).getUnloadedModuleDescription(arg_0));
        if (list2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return "Module with dependents:" + this.myModule.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleWithDependentsScope)) {
            return false;
        }
        ModuleWithDependentsScope moduleWithDependentsScope = (ModuleWithDependentsScope)((Object)o);
        return this.myModule.equals(moduleWithDependentsScope.myModule);
    }

    public int calcHashCode() {
        return this.myModule.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDependents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildDependents";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleIndex {
        final MultiMap<Module, Module> plainUsages = MultiMap.create();
        final MultiMap<Module, Module> exportingUsages = MultiMap.create();

        private ModuleIndex() {
        }
    }
}

