/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import sun.misc.VMSupport;

public class DebugAttachDetector {
    private ScheduledFuture<?> myTask;
    private boolean myAttached;
    private boolean myReady;

    public DebugAttachDetector() {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (!app.isInternal() || app.isUnitTestMode() || app.isHeadlessEnvironment() || Boolean.getBoolean("disable.attach.detector") || PluginManagerCore.isRunningFromSources()) {
            return;
        }
        if (ManagementFactory.getRuntimeMXBean().getInputArguments().stream().noneMatch(s -> s.contains("-agentlib:jdwp"))) {
            return;
        }
        this.myTask = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            boolean attached;
            String property = VMSupport.getAgentProperties().getProperty("sun.jdwp.listenerAddress");
            boolean bl = attached = property != null && property.isEmpty();
            if (!this.myReady) {
                this.myAttached = attached;
                this.myReady = true;
            } else if (attached != this.myAttached) {
                this.myAttached = attached;
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Remote debugger", this.myAttached ? "attached" : "detached", NotificationType.WARNING));
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }
}

