/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf;

import java.util.Objects;
import java.util.Optional;
import org.sejda.common.FriendlyNamed;
import org.sejda.model.pdf.MinRequiredVersion;

public enum PdfVersion implements FriendlyNamed
{
    VERSION_1_0(1.0, "%PDF-1.0"),
    VERSION_1_1(1.1, "%PDF-1.1"),
    VERSION_1_2(1.2, "%PDF-1.2"),
    VERSION_1_3(1.3, "%PDF-1.3"),
    VERSION_1_4(1.4, "%PDF-1.4"),
    VERSION_1_5(1.5, "%PDF-1.5"),
    VERSION_1_6(1.6, "%PDF-1.6"),
    VERSION_1_7(1.7, "%PDF-1.7");

    private double version;
    private String versionHeader;
    private String displayName;

    private PdfVersion(double version, String versionHeader) {
        this.displayName = String.valueOf(version);
        this.version = version;
        this.versionHeader = versionHeader;
    }

    @Override
    public String getFriendlyName() {
        return this.displayName;
    }

    public double getVersion() {
        return this.version;
    }

    public String getVersionString() {
        return String.valueOf(this.version);
    }

    public String getVersionHeader() {
        return this.versionHeader;
    }

    public static PdfVersion getMax(PdfVersion ... pdfVersions) {
        PdfVersion max = null;
        for (PdfVersion current : pdfVersions) {
            if (!Objects.nonNull(current) || !Objects.isNull(max) && max.compareTo(current) >= 0) continue;
            max = current;
        }
        return Optional.ofNullable(max).orElse(VERSION_1_0);
    }

    public static PdfVersion getMax(MinRequiredVersion ... items) {
        PdfVersion max = null;
        for (MinRequiredVersion current : items) {
            if (!Objects.nonNull(current) || !Objects.isNull(max) && max.compareTo(current.getMinVersion()) >= 0) continue;
            max = current.getMinVersion();
        }
        return Optional.ofNullable(max).orElse(VERSION_1_0);
    }
}

