/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;

class ExpressionVisitor
extends ErrorAwareTreePathScanner<Object, Object> {
    private static final EnumSet<Tree.Kind> NUMERIC_OPERATORS = EnumSet.of(Tree.Kind.BITWISE_COMPLEMENT, new Tree.Kind[]{Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.DIVIDE, Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.PLUS, Tree.Kind.REMAINDER, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.XOR});
    private static final EnumSet<Tree.Kind> LOGICAL_OPERATORS = EnumSet.of(Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.OR, Tree.Kind.AND, Tree.Kind.XOR);
    private boolean currentMatches = false;
    private int count;
    private final int threshold;
    private TreePath errorNode;
    private List<TreePath> errorNodes = Collections.emptyList();
    private List<Integer> nodeOperands = Collections.emptyList();
    private final CompilationInfo info;
    private final EnumSet<Tree.Kind> watchOperators;
    private final boolean logical;

    public ExpressionVisitor(CompilationInfo info, boolean logical, int threshold) {
        this.info = info;
        this.threshold = threshold;
        if (logical) {
            this.logical = true;
            this.watchOperators = LOGICAL_OPERATORS;
        } else {
            this.logical = false;
            this.watchOperators = NUMERIC_OPERATORS;
        }
    }

    public List<TreePath> getErrorPaths() {
        return this.errorNodes;
    }

    public int getNodeOperands(TreePath n) {
        int index = this.errorNodes.indexOf(n);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        return this.nodeOperands.get(index);
    }

    private void addError(TreePath n) {
        if (this.errorNodes.isEmpty()) {
            this.errorNodes = new ArrayList<TreePath>(3);
            this.nodeOperands = new ArrayList<Integer>(3);
        }
        this.errorNodes.add(n);
        this.nodeOperands.add(this.count);
    }

    public Object scan(Tree tree, Object p) {
        if (this.currentMatches) {
            this.currentMatches = false;
            Object o = super.scan(tree, p);
            this.currentMatches = true;
            return o;
        }
        int saveCount = this.count;
        TreePath node = this.errorNode;
        this.count = 0;
        this.errorNode = null;
        Object o = super.scan(tree, p);
        if (this.errorNode != null) {
            this.addError(this.errorNode);
        }
        this.currentMatches = false;
        this.errorNode = node;
        this.count = saveCount;
        return o;
    }

    public Object visitParenthesized(ParenthesizedTree node, Object p) {
        boolean b;
        this.currentMatches = b = this.isCorrectType(node);
        Object o = super.visitParenthesized(node, p);
        this.increment(node, b);
        return o;
    }

    public Object visitUnary(UnaryTree node, Object p) {
        boolean b;
        this.currentMatches = b = this.isCorrectType(node);
        Object o = super.visitUnary(node, p);
        this.increment(node, b);
        return o;
    }

    public Object visitBinary(BinaryTree node, Object p) {
        boolean b;
        this.currentMatches = b = this.isCorrectType(node);
        Object o = super.visitBinary(node, p);
        this.increment(node, b);
        return o;
    }

    private void increment(Tree node, boolean b) {
        if (!b) {
            return;
        }
        if (this.watchOperators.contains((Object)node.getKind()) && ++this.count > this.threshold) {
            this.errorNode = this.getCurrentPath();
        }
    }

    private boolean isCorrectType(ExpressionTree t) {
        if (this.currentMatches) {
            return true;
        }
        TypeMirror tm = this.info.getTrees().getTypeMirror(this.getCurrentPath());
        switch (tm.getKind()) {
            case BOOLEAN: {
                return this.logical;
            }
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return !this.logical;
            }
            case DECLARED: {
                return this.info.getTypes().isAssignable(tm, this.info.getTypes().getPrimitiveType(TypeKind.DOUBLE));
            }
        }
        return false;
    }
}

