/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;

final class ScanStatement
extends ErrorAwareTreePathScanner<Void, Void> {
    private static final int PHASE_BEFORE_SELECTION = 1;
    private static final int PHASE_INSIDE_SELECTION = 2;
    private static final int PHASE_AFTER_SELECTION = 3;
    private final CompilationInfo info;
    private int phase = 1;
    private final Tree firstInSelection;
    private final Tree lastInSelection;
    final Set<VariableElement> localVariables = new HashSet<VariableElement>();
    final Map<VariableElement, Boolean> usedLocalVariables = new LinkedHashMap<VariableElement, Boolean>();
    final Set<VariableElement> selectionLocalVariables = new HashSet<VariableElement>();
    final Map<VariableElement, Boolean> usedAfterSelection = new LinkedHashMap<VariableElement, Boolean>();
    final Set<TreePath> selectionExits = new HashSet<TreePath>();
    private final Set<Tree> treesSeensInSelection = new HashSet<Tree>();
    private final Map<TypeMirror, TreePathHandle> typeVar2Def;
    private final Map<Tree, Iterable<? extends TreePath>> assignmentsForUse;
    final Set<TreePathHandle> usedTypeVariables = new HashSet<TreePathHandle>();
    boolean hasReturns = false;
    private boolean hasBreaks = false;
    private boolean hasContinues = false;
    private boolean secondPass = false;
    private boolean stopSecondPass = false;
    private final AtomicBoolean cancel;
    private int nesting;

    public ScanStatement(CompilationInfo info, Tree firstInSelection, Tree lastInSelection, Map<TypeMirror, TreePathHandle> typeVar2Def, Map<Tree, Iterable<? extends TreePath>> assignmentsForUse, AtomicBoolean cancel) {
        this.info = info;
        this.firstInSelection = firstInSelection;
        this.lastInSelection = lastInSelection;
        this.typeVar2Def = typeVar2Def;
        this.assignmentsForUse = assignmentsForUse;
        this.cancel = cancel;
    }

    public Void scan(Tree tree, Void p) {
        if (this.stopSecondPass) {
            return null;
        }
        if (this.phase != 3) {
            if (tree == this.firstInSelection) {
                this.phase = 2;
            }
            if (this.phase == 2) {
                this.treesSeensInSelection.add(tree);
            }
        }
        if (this.secondPass && tree == this.firstInSelection) {
            this.stopSecondPass = true;
            return null;
        }
        super.scan(tree, (Object)p);
        if (tree == this.lastInSelection) {
            this.phase = 3;
        }
        return null;
    }

    public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
        ++this.nesting;
        super.visitLambdaExpression(node, (Object)p);
        --this.nesting;
        return null;
    }

    public Void visitNewClass(NewClassTree node, Void p) {
        ++this.nesting;
        super.visitNewClass(node, (Object)p);
        --this.nesting;
        return null;
    }

    public Void visitClass(ClassTree node, Void p) {
        ++this.nesting;
        super.visitClass(node, (Object)p);
        --this.nesting;
        return null;
    }

    public Void visitVariable(VariableTree node, Void p) {
        Element e = this.info.getTrees().getElement(this.getCurrentPath());
        if (e != null && IntroduceHint.LOCAL_VARIABLES.contains((Object)e.getKind())) {
            switch (this.phase) {
                case 1: {
                    this.localVariables.add((VariableElement)e);
                    break;
                }
                case 2: {
                    this.selectionLocalVariables.add((VariableElement)e);
                }
            }
        }
        return (Void)super.visitVariable(node, (Object)p);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Void visitIdentifier(IdentifierTree node, Void p) {
        block9: {
            e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e == null || !IntroduceHint.LOCAL_VARIABLES.contains((Object)e.getKind())) break block9;
            switch (this.phase) {
                case 2: {
                    if (!this.localVariables.contains(e) || this.usedLocalVariables.get(e) != null) break;
                    writes = this.assignmentsForUse.get(this.getCurrentPath().getLeaf());
                    definitellyAssignedInSelection /* !! */  = true;
                    if (writes == null) ** GOTO lbl14
                    for (TreePath w : writes) {
                        if (w != null && this.treesSeensInSelection.contains(w.getLeaf())) continue;
                        definitellyAssignedInSelection /* !! */  = false;
                        ** GOTO lbl15
                    }
                    ** GOTO lbl15
lbl14:
                    // 1 sources

                    definitellyAssignedInSelection /* !! */  = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ASSIGNMENT ? null : Boolean.valueOf(false);
lbl15:
                    // 3 sources

                    this.usedLocalVariables.put((VariableElement)e, definitellyAssignedInSelection /* !! */ );
                    break;
                }
                case 3: {
                    writes = this.assignmentsForUse.get(this.getCurrentPath().getLeaf());
                    assignedInSelection = false;
                    definitellyAssignedInSelection = true;
                    if (writes != null) {
                        for (TreePath w : writes) {
                            if (w != null && this.treesSeensInSelection.contains(w.getLeaf())) {
                                assignedInSelection = true;
                            }
                            if (w != null && this.treesSeensInSelection.contains(w.getLeaf())) continue;
                            definitellyAssignedInSelection = false;
                        }
                    }
                    if (!assignedInSelection) break;
                    this.usedAfterSelection.put((VariableElement)e, definitellyAssignedInSelection);
                }
            }
        }
        if (this.phase == 2 && (type = this.info.getTrees().getTypeMirror(this.getCurrentPath())) != null) {
            def = this.typeVar2Def.get(type);
            this.usedTypeVariables.add(def);
        }
        return (Void)super.visitIdentifier(node, (Object)p);
    }

    public Collection<TreePathHandle> getTypeVarDefs() {
        return this.typeVar2Def.values();
    }

    public List<TreePathHandle> getUsedTypeVars() {
        ArrayList<TreePathHandle> ll = new ArrayList<TreePathHandle>(this.getTypeVarDefs());
        ll.retainAll(this.usedTypeVariables);
        return ll;
    }

    private boolean isMethodCode() {
        return this.nesting == 0;
    }

    public Void visitReturn(ReturnTree node, Void p) {
        if (this.isMethodCode() && this.phase == 2) {
            this.selectionExits.add(this.getCurrentPath());
            this.hasReturns = true;
        }
        return (Void)super.visitReturn(node, (Object)p);
    }

    public Void visitBreak(BreakTree node, Void p) {
        if (this.isMethodCode() && this.phase == 2 && !this.treesSeensInSelection.contains(this.info.getTreeUtilities().getBreakContinueTargetTree(this.getCurrentPath()))) {
            this.selectionExits.add(this.getCurrentPath());
            this.hasBreaks = true;
        }
        return (Void)super.visitBreak(node, (Object)p);
    }

    public Void visitContinue(ContinueTree node, Void p) {
        if (this.isMethodCode() && this.phase == 2 && !this.treesSeensInSelection.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
            this.selectionExits.add(this.getCurrentPath());
            this.hasContinues = true;
        }
        return (Void)super.visitContinue(node, (Object)p);
    }

    public Void visitWhileLoop(WhileLoopTree node, Void p) {
        super.visitWhileLoop(node, (Object)p);
        if (this.isMethodCode() && this.phase == 3 && !this.secondPass) {
            this.secondPass = true;
            this.scan((Tree)node.getCondition(), p);
            this.scan((Tree)node.getStatement(), p);
            this.secondPass = false;
            this.stopSecondPass = false;
        }
        return null;
    }

    public Void visitForLoop(ForLoopTree node, Void p) {
        super.visitForLoop(node, (Object)p);
        if (this.isMethodCode() && this.phase == 3 && !this.secondPass) {
            this.secondPass = true;
            this.scan((Tree)node.getCondition(), p);
            this.scan(node.getUpdate(), p);
            this.scan((Tree)node.getStatement(), p);
            this.secondPass = false;
            this.stopSecondPass = false;
        }
        return null;
    }

    public Void visitDoWhileLoop(DoWhileLoopTree node, Void p) {
        super.visitDoWhileLoop(node, (Object)p);
        if (this.isMethodCode() && this.phase == 3 && !this.secondPass) {
            this.secondPass = true;
            this.scan((Tree)node.getStatement(), p);
            this.secondPass = false;
            this.stopSecondPass = false;
        }
        return null;
    }

    String verifyExits(boolean exitsFromAllBranches) {
        int i = 0;
        i += this.hasReturns ? 1 : 0;
        i += this.hasBreaks ? 1 : 0;
        if ((i += this.hasContinues ? 1 : 0) > 1) {
            return "ERR_Too_Many_Different_Exits";
        }
        if ((exitsFromAllBranches ? 0 : i) + this.usedAfterSelection.size() > 1) {
            return "ERR_Too_Many_Return_Values";
        }
        Tree breakOrContinueTarget = null;
        boolean returnValueComputed = false;
        TreePath returnValue = null;
        for (TreePath tp : this.selectionExits) {
            if (tp.getLeaf().getKind() == Tree.Kind.RETURN) {
                Set candidates;
                TreePath currentReturnValue;
                if (exitsFromAllBranches) continue;
                ReturnTree rt = (ReturnTree)tp.getLeaf();
                TreePath treePath = currentReturnValue = rt.getExpression() != null ? new TreePath(tp, rt.getExpression()) : null;
                if (!returnValueComputed) {
                    returnValue = currentReturnValue;
                    returnValueComputed = true;
                    continue;
                }
                if (!(returnValue != null && currentReturnValue != null ? (candidates = SourceUtils.computeDuplicates((CompilationInfo)this.info, (TreePath)returnValue, (TreePath)currentReturnValue, (AtomicBoolean)this.cancel)).size() != 1 || ((TreePath)candidates.iterator().next()).getLeaf() != rt.getExpression() : returnValue != currentReturnValue)) continue;
                return "ERR_Different_Return_Values";
            }
            Tree target = this.info.getTreeUtilities().getBreakContinueTargetTree(tp);
            if (breakOrContinueTarget == null) {
                breakOrContinueTarget = target;
            }
            if (breakOrContinueTarget == target) continue;
            return "ERR_Break_Mismatch";
        }
        return null;
    }
}

