/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.loader.Bundle;
import org.openide.cookies.LineCookie;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class SQLExecutionLoggerImpl
implements SQLExecutionLogger {
    private final LineCookie lineCookie;
    private final InputOutput inputOutput;
    private boolean inputOutputSelected = false;
    private int errorCount;
    private static final Logger LOG = Logger.getLogger(SQLExecutionLoggerImpl.class.getName());

    public SQLExecutionLoggerImpl(String displayName, LineCookie lineCookie) {
        this.lineCookie = lineCookie;
        String ioName = Bundle.LBL_SQLFileExecution(displayName);
        this.inputOutput = IOProvider.getDefault().getIO(ioName, true);
    }

    public SQLExecutionLoggerImpl(String displayName) {
        this(displayName, null);
    }

    @Override
    public void log(SQLExecutionResult result) {
        this.logWarnings(result);
        if (result.hasExceptions()) {
            this.logException(result);
        } else {
            this.logSuccess(result);
        }
    }

    @Override
    public void finish(long executionTime) {
        try (OutputWriter writer = this.inputOutput.getOut();){
            writer.println("");
            writer.println(Bundle.LBL_ExecutionFinished((double)executionTime / 1000.0, this.errorCount));
        }
        this.inputOutput.select();
    }

    @Override
    public void cancel() {
        try (OutputWriter writer = this.inputOutput.getErr();){
            writer.println(Bundle.LBL_ExecutionCancelled());
            writer.println("");
        }
    }

    public void close() {
        this.inputOutput.closeInputOutput();
    }

    private void logWarnings(SQLExecutionResult result) {
        if (!result.getWarnings().isEmpty()) {
            try (OutputWriter writer = this.inputOutput.getOut();){
                for (SQLWarning s : result.getWarnings()) {
                    this.writeSQLWarning(s, writer);
                }
                writer.println("");
            }
        }
    }

    private void logException(SQLExecutionResult result) {
        ++this.errorCount;
        if (!this.inputOutputSelected) {
            this.inputOutputSelected = true;
            this.inputOutput.select();
        }
        try (OutputWriter writer = this.inputOutput.getErr();){
            this.startLineColumn(writer, result, Bundle.LBL_ExecutionFailed((double)result.getExecutionTime() / 1000.0));
            for (Throwable e : result.getExceptions()) {
                if (e instanceof SQLException) {
                    this.writeSQLException((SQLException)e, writer);
                    continue;
                }
                this.writeGenericException(e, writer);
            }
            this.printLineColumn(writer, result, true);
            writer.println("");
        }
    }

    private void writeSQLWarning(SQLWarning e, OutputWriter writer) {
        writer.println(Bundle.LBL_WarningCodeStateMessage(e.getErrorCode(), e.getSQLState(), e.getMessage()));
    }

    private void writeSQLException(SQLException e, OutputWriter writer) {
        while (e != null) {
            writer.println(Bundle.LBL_ErrorCodeStateMessage(e.getErrorCode(), e.getSQLState(), e.getMessage()));
            e = e.getNextException();
        }
    }

    private void writeGenericException(Throwable e, OutputWriter writer) {
        LOG.log(Level.INFO, "Exception in SQL Execution", e);
        writer.println(Bundle.LBL_ExceptionMessage(e.getMessage(), e.getClass().getName()));
    }

    private void logSuccess(SQLExecutionResult result) {
        try (OutputWriter writer = this.inputOutput.getOut();){
            this.startLineColumn(writer, result, Bundle.LBL_ExecutedSuccessfullyTime((double)result.getExecutionTime() / 1000.0));
            List<Integer> updateCounts = result.getUpdateCounts();
            List<Long> fetchTimes = result.getFetchTimes();
            for (int i = 0; i < Math.max(updateCounts.size(), fetchTimes.size()); ++i) {
                Long fetchTime;
                Integer updateCount = updateCounts.size() > i ? updateCounts.get(i) : null;
                Long l = fetchTime = fetchTimes.size() > i ? fetchTimes.get(i) : null;
                if (updateCount != null && updateCount >= 0) {
                    writer.println(Bundle.LBL_ExecutedRowsAffected(updateCount));
                }
                if (fetchTime == null) continue;
                writer.println(Bundle.LBL_ExecutedFetchTime((double)fetchTime.longValue() / 1000.0));
            }
            writer.println("");
        }
    }

    private void startLineColumn(OutputWriter writer, SQLExecutionResult result, String message) {
        int line = result.getStatementInfo().getStartLine();
        int col = result.getStatementInfo().getStartColumn();
        String text = String.format("[%d:%d] %s", line + 1, col + 1, message);
        Hyperlink link = new Hyperlink(line, col);
        try {
            writer.println(text, (OutputListener)link);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void printLineColumn(OutputWriter writer, SQLExecutionResult result, boolean hyperlink) {
        int[] errorCoords = result.getRawErrorLocation();
        int errLine = errorCoords[0];
        int errCol = errorCoords[1];
        String lineColumn = "  " + Bundle.LBL_LineColumn(errLine + 1, errCol + 1);
        try {
            if (hyperlink) {
                Hyperlink errLink = new Hyperlink(errLine, errCol);
                writer.println(lineColumn, (OutputListener)errLink);
            } else {
                writer.println(lineColumn);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private final class Hyperlink
    implements OutputListener {
        private final Line line;
        private final int column;

        public Hyperlink(int line, int column) {
            this.line = SQLExecutionLoggerImpl.this.lineCookie.getLineSet().getCurrent(line);
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
            this.goToLine(false);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.goToLine(true);
        }

        private void goToLine(boolean focus) {
            if (!this.line.isDeleted()) {
                this.line.show(focus ? 2 : 0, this.column);
            }
        }
    }
}

