/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.navigation;

import java.util.Collection;
import javax.swing.JComponent;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.navigation.Bundle;
import org.netbeans.modules.jshell.navigation.SnippetPanelUI;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class SnippetNavigationPanel
implements NavigatorPanel {
    private SnippetPanelUI ui;
    private static SnippetNavigationPanel INSTANCE = null;
    private Lookup context;
    private Lookup.Result<FileObject> lkp;
    private LookupListener lookupL = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            SnippetNavigationPanel.this.navigateToFile((FileObject)SnippetNavigationPanel.this.context.lookup(FileObject.class));
        }
    };

    public static void navigate(SnippetHandle h) {
        if (INSTANCE != null) {
            INSTANCE.getUI().navigateToHandle(h);
        }
    }

    public String getDisplayName() {
        return Bundle.LBL_NavigatorPanel();
    }

    public String getDisplayHint() {
        return Bundle.HINT_NavigatorPanel();
    }

    public JComponent getComponent() {
        return this.getUI();
    }

    private void navigateToFile(FileObject file) {
        JShellEnvironment env = ShellRegistry.get().get(file);
        if (env == null) {
            return;
        }
        this.getUI().navigate(env);
    }

    public void panelActivated(Lookup context) {
        this.lkp = context.lookupResult(FileObject.class);
        this.lkp.addLookupListener(this.lookupL);
        Collection l = this.lkp.allInstances();
        FileObject file = l.isEmpty() ? null : (FileObject)l.iterator().next();
        this.navigateToFile(file);
        this.context = context;
        INSTANCE = this;
    }

    private SnippetPanelUI getUI() {
        if (this.ui == null) {
            this.ui = new SnippetPanelUI();
        }
        return this.ui;
    }

    public void panelDeactivated() {
        if (this.lkp != null) {
            this.lkp.removeLookupListener(this.lookupL);
        }
        INSTANCE = null;
        this.getUI().unselectAll();
        this.context = null;
    }

    public Lookup getLookup() {
        return this.getUI().getLookup();
    }
}

