/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOptionOneArgument;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

public class PropertiesOption
extends CLIOptionOneArgument {
    public static final String PROPERTIES_ARG = "--properties";
    private static final String WARNING_BAD_PROPERTIES_ARG_KEY = "O.warning.bad.properties.arg";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CLIArgumentsList arguments) throws CLIOptionException {
        File propertiesFile = new File(arguments.next());
        FileInputStream is = null;
        try {
            is = new FileInputStream(propertiesFile);
            Properties props = new Properties();
            props.load(is);
            System.getProperties().putAll((Map<?, ?>)props);
        }
        catch (IOException e) {
            LogManager.log(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LogManager.log(e);
                }
            }
        }
    }

    @Override
    protected String getLackOfArgumentsMessage() {
        return ResourceUtils.getString(PropertiesOption.class, WARNING_BAD_PROPERTIES_ARG_KEY, PROPERTIES_ARG);
    }

    @Override
    public String getName() {
        return PROPERTIES_ARG;
    }
}

