/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryCurrentScopeVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class TemporaryLocalVariable
extends TemporaryVariable {
    public static final String PREFIX = "%v_";
    public final int offset;

    public TemporaryLocalVariable(int offset2) {
        this.offset = offset2;
    }

    @Override
    public String getId() {
        return this.getPrefix() + this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public TemporaryVariableType getType() {
        return TemporaryVariableType.LOCAL;
    }

    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Variable clone(SimpleCloneInfo ii) {
        return this;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        Object o = temp[this.offset];
        return o == null ? context.nil : o;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode((byte)this.getType().ordinal());
        e.encode(this.offset);
    }

    public static TemporaryLocalVariable decode(IRReaderDecoder d) {
        TemporaryVariableType type2 = d.decodeTemporaryVariableType();
        switch (type2) {
            case CLOSURE: {
                return TemporaryClosureVariable.decode(d);
            }
            case CURRENT_MODULE: {
                return TemporaryCurrentModuleVariable.decode(d);
            }
            case CURRENT_SCOPE: {
                return TemporaryCurrentScopeVariable.decode(d);
            }
            case FLOAT: {
                return TemporaryFloatVariable.decode(d);
            }
            case FIXNUM: {
                return TemporaryFixnumVariable.decode(d);
            }
            case BOOLEAN: {
                return TemporaryBooleanVariable.decode(d);
            }
            case LOCAL: {
                return d.getCurrentScope().getManager().newTemporaryLocalVariable(d.decodeInt());
            }
        }
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.TemporaryLocalVariable(this);
    }
}

