/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;

@JadxVisitor(name="FixAccessModifiers", desc="Change class and method access modifiers if needed", runAfter={ModVisitor.class})
public class FixAccessModifiers
extends AbstractVisitor {
    private boolean respectAccessModifiers;

    @Override
    public void init(RootNode root) {
        this.respectAccessModifiers = root.getArgs().isRespectBytecodeAccModifiers();
    }

    @Override
    public void visit(MethodNode mth) {
        AccessInfo newAccFlags;
        if (this.respectAccessModifiers) {
            return;
        }
        AccessInfo accessFlags = mth.getAccessFlags();
        int newVisFlag = this.fixVisibility(mth, accessFlags);
        if (newVisFlag != 0 && (newAccFlags = accessFlags.changeVisibility(newVisFlag)) != accessFlags) {
            mth.setAccFlags(newAccFlags);
            mth.addAttr(AType.COMMENTS, "Access modifiers changed, original: " + accessFlags.rawString());
        }
    }

    private int fixVisibility(MethodNode mth, AccessInfo accessFlags) {
        if (mth.isVirtual()) {
            return 1;
        }
        if (accessFlags.isAbstract()) {
            return 1;
        }
        if (accessFlags.isConstructor() || accessFlags.isStatic()) {
            return 0;
        }
        return 2;
    }
}

