/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class LocalVariableDescriptor
extends VariableDescriptorWithInitializerImpl
implements VariableDescriptorWithAccessors {
    private final boolean isDelegated;
    private final boolean isLateInit;
    private LocalVariableAccessorDescriptor.Getter getter;
    private LocalVariableAccessorDescriptor.Setter setter;

    public LocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @Nullable KotlinType type2, boolean mutable, boolean isDelegated, boolean isLateInit, @NotNull SourceElement source) {
        super(containingDeclaration, annotations2, name, type2, mutable, source);
        this.isDelegated = isDelegated;
        this.isLateInit = isLateInit;
    }

    public LocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @Nullable KotlinType type2, boolean mutable, boolean isDelegated, @NotNull SourceElement source) {
        this(containingDeclaration, annotations2, name, type2, mutable, isDelegated, false, source);
    }

    public LocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @Nullable KotlinType type2, @NotNull SourceElement source) {
        this(containingDeclaration, annotations2, name, type2, false, false, false, source);
    }

    @Override
    public void setOutType(KotlinType outType) {
        super.setOutType(outType);
        if (this.isDelegated) {
            this.getter = new LocalVariableAccessorDescriptor.Getter(this);
            if (this.isVar()) {
                this.setter = new LocalVariableAccessorDescriptor.Setter(this);
            }
        }
    }

    @Override
    @NotNull
    public LocalVariableDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2.isEmpty()) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitVariableDescriptor(this, data);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.LOCAL;
    }

    @Override
    @Nullable
    public LocalVariableAccessorDescriptor.Getter getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public LocalVariableAccessorDescriptor.Setter getSetter() {
        return this.setter;
    }

    @Override
    public boolean isDelegated() {
        return this.isDelegated;
    }

    @Override
    public boolean isLateInit() {
        return this.isLateInit;
    }
}

