/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.logging.text.TreeFormatter;

class InjectUtil {
    InjectUtil() {
    }

    public static <T> ClassGenerator.GeneratedConstructor<T> selectConstructor(ClassGenerator.GeneratedClass<T> type, Class<?> reportAs) {
        TreeFormatter formatter3;
        List<ClassGenerator.GeneratedConstructor<T>> constructors = type.getConstructors();
        if (constructors.size() == 1) {
            ClassGenerator.GeneratedConstructor<T> constructor = constructors.get(0);
            if (constructor.getParameterTypes().length == 0 && InjectUtil.isPublicOrPackageScoped(type.getGeneratedClass(), constructor)) {
                return constructor;
            }
            if (constructor.getAnnotation(Inject.class) != null) {
                return constructor;
            }
            if (constructor.getParameterTypes().length == 0) {
                TreeFormatter formatter2 = new TreeFormatter();
                formatter2.node("The constructor for ");
                formatter2.appendType(reportAs);
                formatter2.append((CharSequence)" should be public or package protected or annotated with @Inject.");
                throw new IllegalArgumentException(formatter2.toString());
            }
            TreeFormatter formatter3 = new TreeFormatter();
            formatter3.node("The constructor for ");
            formatter3.appendType(reportAs);
            formatter3.append((CharSequence)" should be annotated with @Inject.");
            throw new IllegalArgumentException(formatter3.toString());
        }
        ArrayList<ClassGenerator.GeneratedConstructor<T>> injectConstructors = new ArrayList<ClassGenerator.GeneratedConstructor<T>>();
        for (ClassGenerator.GeneratedConstructor<T> constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            injectConstructors.add(constructor);
        }
        if (injectConstructors.isEmpty()) {
            formatter3 = new TreeFormatter();
            formatter3.node(reportAs);
            formatter3.append((CharSequence)" has no constructor that is annotated with @Inject.");
            throw new IllegalArgumentException(formatter3.toString());
        }
        if (injectConstructors.size() > 1) {
            formatter3 = new TreeFormatter();
            formatter3.node(reportAs);
            formatter3.append((CharSequence)" has multiple constructors that are annotated with @Inject.");
            throw new IllegalArgumentException(formatter3.toString());
        }
        return (ClassGenerator.GeneratedConstructor)injectConstructors.get(0);
    }

    private static boolean isPublicOrPackageScoped(Class<?> type, ClassGenerator.GeneratedConstructor<?> constructor) {
        if (InjectUtil.isPackagePrivate(type.getModifiers())) {
            return !Modifier.isPrivate(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers());
        }
        return Modifier.isPublic(constructor.getModifiers());
    }

    private static boolean isPackagePrivate(int modifiers) {
        return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
    }
}

