/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class PropertiesAssociations
implements Serializable {
    private final Map<String, NodeProperties> titleToNodeProperty = new HashMap<String, NodeProperties>();
    private final Map<String, EdgeProperties> titleToEdgeProperty = new HashMap<String, EdgeProperties>();

    public void addNodePropertyAssociation(NodeProperties property, String title) {
        this.titleToNodeProperty.put(title, property);
    }

    public void addEdgePropertyAssociation(EdgeProperties property, String title) {
        this.titleToEdgeProperty.put(title, property);
    }

    public NodeProperties getNodeProperty(String title) {
        if (this.titleToNodeProperty.containsKey(title)) {
            return this.titleToNodeProperty.get(title);
        }
        return null;
    }

    public EdgeProperties getEdgeProperty(String title) {
        if (this.titleToEdgeProperty.containsKey(title)) {
            return this.titleToEdgeProperty.get(title);
        }
        return null;
    }

    public String getInfos() {
        StringBuilder builder = new StringBuilder("***Node Properties Associations***\n");
        for (Map.Entry<String, NodeProperties> entry : this.titleToNodeProperty.entrySet()) {
            builder.append("Property ").append(entry.getValue().name()).append(" = ").append(entry.getKey()).append(" Column\n");
        }
        builder.append("*********************************\n");
        builder.append("***Edge Properties Associations***\n");
        for (Map.Entry<String, Enum> entry : this.titleToEdgeProperty.entrySet()) {
            builder.append("Property ").append(((EdgeProperties)entry.getValue()).name()).append(" = ").append(entry.getKey()).append(" Column\n");
        }
        builder.append("*********************************\n");
        return builder.toString();
    }

    public static enum EdgeProperties {
        R,
        G,
        B,
        COLOR,
        WEIGHT,
        ID,
        LABEL,
        ALPHA,
        SOURCE,
        TARGET,
        START,
        END,
        START_OPEN,
        END_OPEN;

    }

    public static enum NodeProperties {
        X,
        Y,
        Z,
        R,
        G,
        B,
        COLOR,
        SIZE,
        ID,
        LABEL,
        FIXED,
        START,
        END,
        START_OPEN,
        END_OPEN;

    }
}

