/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.Iterator;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;

public class AP1934
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1934(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (!entryContext.getMessageEntry().isMimeContent()) {
            this.result = "notApplicable";
        } else {
            MimeParts parts = entryContext.getMessageEntry().getMimeParts();
            if (parts.count() == 0) {
                this.result = "notApplicable";
            } else {
                Iterator iparts = parts.getParts().iterator();
                int i = 0;
                while (iparts.hasNext()) {
                    MimePart part = (MimePart)iparts.next();
                    String type_value = MIMEUtils.getMimeHeaderAttribute(part.getHeaders(), "Content-Transfer-Encoding");
                    if (!(type_value == null || type_value != null && (type_value.equalsIgnoreCase("7bit") || type_value.equalsIgnoreCase("8bit") || type_value.equalsIgnoreCase("base64") || type_value.equalsIgnoreCase("quoted-printable") || type_value.equalsIgnoreCase("binary")))) {
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail("(" + (i + 1) + "), part header field \"Content-Transfer-Encoding\" has incorrect value \"" + type_value + "\"", entryContext);
                    }
                    ++i;
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

