/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SystemSafeFileOutputStream
extends OutputStream {
    protected File destination = null;
    protected File temp = null;
    protected OutputStream output = null;
    protected boolean failed = false;
    protected static final String BACKUP_EXTENSION = ".bak";

    public SystemSafeFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath(), null);
    }

    public SystemSafeFileOutputStream(String destinationName) throws IOException {
        this(destinationName, null);
    }

    public SystemSafeFileOutputStream(String destinationPath, String tempPath) throws IOException {
        this.destination = new File(destinationPath);
        this.createTempFile(tempPath);
        if (!this.destination.exists()) {
            if (!this.temp.exists()) {
                this.output = new BufferedOutputStream(new FileOutputStream(this.destination));
                return;
            }
            this.copy(this.temp, this.destination);
        }
        this.output = new BufferedOutputStream(new FileOutputStream(this.temp));
    }

    public void close() throws IOException {
        try {
            this.output.close();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
        if (this.failed) {
            this.temp.delete();
        } else {
            this.commit();
        }
    }

    protected void commit() throws IOException {
        if (!this.temp.exists()) {
            return;
        }
        this.destination.delete();
        this.copy(this.temp, this.destination);
        this.temp.delete();
    }

    protected void copy(File sourceFile, File destinationFile) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        FileInputStream source = new FileInputStream(sourceFile);
        FileOutputStream destination = new FileOutputStream(destinationFile);
        this.transferData(source, destination);
    }

    protected void createTempFile(String tempPath) throws IOException {
        if (tempPath == null) {
            tempPath = String.valueOf(this.destination.getAbsolutePath()) + BACKUP_EXTENSION;
        }
        this.temp = new File(tempPath);
    }

    public void flush() throws IOException {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    public String getTempFilePath() {
        return this.temp.getAbsolutePath();
    }

    protected void transferData(InputStream source, OutputStream destination) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void write(int b) throws IOException {
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }
}

