/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RestartFrameExtension;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ExpressionTracker;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptThread;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrameBase;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Variable;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePosition;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMap;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.JavaScriptExpressionBuilder;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;

public class StackFrame
extends StackFrameBase
implements IDropToFrame,
IJavaScriptStackFrame {
    private final CallFrame stackFrame;
    private IVariable[] variables;
    private volatile CachedUserPosition userCachedSourcePosition = null;
    private static final Comparator<Variable> VARIABLE_COMPARATOR = new Comparator<Variable>(){
        private static final int COMPARE_LONG_WITH_STRING = 1;

        @Override
        public int compare(Variable var1, Variable var2) {
            return this.compareNameObjects(this.getNameObject(var1), this.getNameObject(var2));
        }

        private Object getNameObject(Variable var) {
            String name = var.getName();
            Long num = JavaScriptExpressionBuilder.parsePropertyNameAsArrayIndex((String)name);
            if (num != null) {
                return num;
            }
            return name;
        }

        private int compareNameObjects(Object nameObj1, Object nameObj2) {
            if (nameObj1 instanceof Long) {
                Long n1 = (Long)nameObj1;
                if (nameObj2 instanceof Long) {
                    Long n2 = (Long)nameObj2;
                    return n1.compareTo(n2);
                }
                return 1;
            }
            String s1 = (String)nameObj1;
            if (nameObj2 instanceof String) {
                String s2 = (String)nameObj2;
                return s1.compareTo(s2);
            }
            return -1;
        }
    };

    public StackFrame(JavascriptThread.SuspendedState threadState, CallFrame stackFrame) {
        super(new EvaluateContext(stackFrame.getEvaluateContext(), threadState));
        this.stackFrame = stackFrame;
    }

    public CallFrame getCallFrame() {
        return this.stackFrame;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables == null) {
            try {
                this.variables = StackFrame.wrapScopes(this.getEvaluateContext(), this.stackFrame.getVariableScopes(), this.stackFrame.getReceiverVariable(), ExpressionTracker.STACK_FRAME_FACTORY);
            }
            catch (RuntimeException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to read variables", (Throwable)e));
            }
        }
        return this.variables;
    }

    static IVariable[] wrapVariables(EvaluateContext evaluateContext, Collection<? extends JsVariable> jsVars, Set<? extends String> propertyNameBlackList, Collection<? extends JsVariable> jsInternalProperties, Collection<? extends Variable> additional, ExpressionTracker.Node expressionNode) {
        ExpressionTracker.Node expressionTrackerNode;
        ArrayList<? extends Variable> vars = new ArrayList<Variable>(jsVars.size());
        for (JsVariable jsVariable : jsVars) {
            if (propertyNameBlackList.contains(jsVariable.getName())) continue;
            expressionTrackerNode = expressionNode.createVariableNode(jsVariable, false);
            vars.add(Variable.forRealValue(evaluateContext, jsVariable, false, expressionTrackerNode));
        }
        Collections.sort(vars, VARIABLE_COMPARATOR);
        if (jsInternalProperties != null) {
            for (JsVariable jsVariable : jsInternalProperties) {
                expressionTrackerNode = expressionNode.createVariableNode(jsVariable, true);
                vars.add(Variable.forRealValue(evaluateContext, jsVariable, true, expressionTrackerNode));
            }
        }
        if (additional != null) {
            vars.addAll(additional);
        }
        return vars.toArray(new IVariable[vars.size()]);
    }

    static IVariable[] wrapScopes(final EvaluateContext evaluateContext, List<? extends JsScope> jsScopes, JsVariable receiverVariable, final ExpressionTracker.ScopeAndVariableFactory trackerNodeFactory) {
        final ArrayList<Variable> vars = new ArrayList<Variable>();
        JsScope.Visitor<Void> scopeVisitor = new JsScope.Visitor<Void>(){

            public Void visitDeclarative(JsScope.Declarative declarativeScope) {
                int startPos = vars.size();
                for (JsVariable var : declarativeScope.getVariables()) {
                    vars.add(Variable.forRealValue(evaluateContext, var, false, trackerNodeFactory.createVariableNode(var, false)));
                }
                int endPos = vars.size();
                List sublist = vars.subList(startPos, endPos);
                Collections.sort(sublist, VARIABLE_COMPARATOR);
                return null;
            }

            public Void visitObject(JsScope.ObjectBased objectScope) {
                vars.add(Variable.forObjectScope(evaluateContext, objectScope, trackerNodeFactory.createScopeNode()));
                return null;
            }
        };
        for (JsScope jsScope : jsScopes) {
            if (jsScope.getType() == JsScope.Type.GLOBAL && receiverVariable != null) {
                ExpressionTracker.Node expressionTrackerNode = trackerNodeFactory.createVariableNode(receiverVariable, false);
                vars.add(Variable.forRealValue(evaluateContext, receiverVariable, false, expressionTrackerNode));
                receiverVariable = null;
            }
            jsScope.accept((JsScope.Visitor)scopeVisitor);
        }
        if (receiverVariable != null) {
            vars.add(Variable.forRealValue(evaluateContext, receiverVariable, false, trackerNodeFactory.createVariableNode(receiverVariable, false)));
        }
        IVariable[] iVariableArray = new IVariable[vars.size()];
        int i = 0;
        while (i < iVariableArray.length) {
            iVariableArray[iVariableArray.length - i - 1] = (IVariable)vars.get(i);
            ++i;
        }
        return iVariableArray;
    }

    public boolean hasVariables() throws DebugException {
        return this.stackFrame.getReceiverVariable() != null || this.stackFrame.getVariableScopes().size() > 0;
    }

    public boolean canDropToFrame() {
        RestartFrameExtension resetFrameExtension = this.getSdkResetFrameExtension();
        return resetFrameExtension != null && resetFrameExtension.canRestartFrame(this.stackFrame);
    }

    public void dropToFrame() throws DebugException {
        GenericCallback<Boolean> callback = new GenericCallback<Boolean>(){

            public void success(Boolean stackResumed) {
                stackResumed.booleanValue();
            }

            public void failure(Exception exception) {
                ChromiumDebugPlugin.log(new Exception("Failed to 'drop to frame' action", exception));
            }
        };
        SyncCallback syncCallback = new SyncCallback(){

            public void callbackDone(RuntimeException e) {
                if (e != null) {
                    ChromiumDebugPlugin.log(e);
                }
            }
        };
        this.getSdkResetFrameExtension().restartFrame(this.stackFrame, (GenericCallback)callback, syncCallback);
    }

    private RestartFrameExtension getSdkResetFrameExtension() {
        return this.getConnectedData().getJavascriptVm().getRestartFrameExtension();
    }

    public int getLineNumber() throws DebugException {
        return this.getUserPosition().getLine() + 1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return this.getCharStart();
    }

    public String getName() throws DebugException {
        return this.getDebugTarget().getLabelProvider().getStackFrameLabel(this);
    }

    @Override
    Object getObjectForEquals() {
        return this.stackFrame;
    }

    @Override
    boolean isRegularFrame() {
        return true;
    }

    private SourcePosition getUserPosition() {
        CachedUserPosition currentCachedPosition = this.userCachedSourcePosition;
        if (currentCachedPosition == null || currentCachedPosition.token.isUpdated()) {
            Script script = this.stackFrame.getScript();
            VmResourceId id = script == null ? null : VmResourceId.forScript(script);
            TextStreamPosition vmPosition = this.stackFrame.getStatementStartPosition();
            SourcePositionMap sourceTransformationMap = this.getConnectedData().getSourcePositionMap();
            SourcePositionMap.Token token = sourceTransformationMap.getCurrentToken();
            SourcePosition originalPosition = id == null ? new SourcePosition(id, vmPosition.getLine(), vmPosition.getColumn()) : sourceTransformationMap.translatePosition(id, vmPosition.getLine(), vmPosition.getColumn(), SourcePositionMap.TranslateDirection.VM_TO_USER);
            this.userCachedSourcePosition = currentCachedPosition = new CachedUserPosition(originalPosition, token);
        }
        return currentCachedPosition.position;
    }

    public VmResourceId getVmResourceId() {
        return this.getUserPosition().getId();
    }

    public IJavaScriptValue evaluate(String expression) {
        final JsValue[] result = new JsValue[1];
        this.getEvaluateContext().getJsEvaluateContext().evaluateSync(expression, Collections.emptyMap(), new JsEvaluateContext.EvaluateCallback(){

            public void success(JsEvaluateContext.ResultOrException valueOrException) {
                result[0] = (JsValue)valueOrException.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<JsValue>(){

                    public JsValue visitResult(JsValue value) {
                        return value;
                    }

                    public JsValue visitException(JsValue exception) {
                        return null;
                    }
                });
            }

            public void failure(Exception cause) {
            }
        });
        if (result[0] != null) {
            return new IJavaScriptValue(){

                public <T> T getAdapter(Class<T> adapter) {
                    return null;
                }

                public String getModelIdentifier() {
                    return "org.eclipse.wst.jsdt.chromium.debug.core";
                }

                public ILaunch getLaunch() {
                    return StackFrame.this.getConnectedData().getDebugTarget().getLaunch();
                }

                public IDebugTarget getDebugTarget() {
                    return StackFrame.this.getConnectedData().getDebugTarget();
                }

                public boolean isAllocated() throws DebugException {
                    return true;
                }

                public boolean hasVariables() throws DebugException {
                    return false;
                }

                public IVariable[] getVariables() throws DebugException {
                    return null;
                }

                public String getValueString() throws DebugException {
                    return result[0].getValueString();
                }

                public String getReferenceTypeName() throws DebugException {
                    return result[0].getType().toString();
                }

                public boolean isNull() {
                    return result[0].getType() == JsValue.Type.TYPE_NULL;
                }

                public String getDetailString() {
                    return result[0].getValueString();
                }
            };
        }
        return null;
    }

    public String getSourceName() {
        if (this.stackFrame.getScript() == null) {
            return null;
        }
        return this.stackFrame.getScript().getName();
    }

    public String getSourcePath() {
        if (this.stackFrame.getScript() == null) {
            return null;
        }
        return this.stackFrame.getScript().getName();
    }

    public String getSource() {
        if (this.stackFrame.getScript() == null) {
            return null;
        }
        return this.stackFrame.getScript().getSource();
    }

    public IVariable getThisObject() {
        return null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IJavaScriptStackFrame.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private final class CachedUserPosition {
        final SourcePosition position;
        final SourcePositionMap.Token token;

        CachedUserPosition(SourcePosition position, SourcePositionMap.Token token) {
            this.position = position;
            this.token = token;
        }
    }
}

