/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.PackagePermission;

public final class BundlePermissions
extends PermissionCollection {
    private static final long serialVersionUID = -5443618108312606612L;
    static final Enumeration<Permission> EMPTY_ENUMERATION = new Enumeration<Permission>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Permission nextElement() {
            throw new NoSuchElementException();
        }
    };
    private final Bundle bundle;
    private final SecurityAdmin securityAdmin;
    private final PermissionInfoCollection impliedPermissions;
    private final PermissionInfoCollection restrictedPermissions;
    private final Permissions wovenPermissions;

    public BundlePermissions(Bundle bundle, SecurityAdmin securityAdmin, PermissionInfoCollection impliedPermissions, PermissionInfoCollection restrictedPermissions) {
        this.bundle = bundle;
        this.securityAdmin = securityAdmin;
        this.impliedPermissions = impliedPermissions;
        this.restrictedPermissions = restrictedPermissions;
        this.wovenPermissions = new Permissions();
        this.setReadOnly();
    }

    @Override
    public void add(Permission permission) {
        throw new SecurityException();
    }

    public void addWovenPermission(PackagePermission permission) {
        if (!permission.getActions().equals("import")) {
            throw new SecurityException();
        }
        this.wovenPermissions.add(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        return EMPTY_ENUMERATION;
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.impliedPermissions != null && this.impliedPermissions.implies(permission)) {
            return true;
        }
        if (this.wovenPermissions.implies(permission)) {
            return true;
        }
        if (this.restrictedPermissions != null && !this.restrictedPermissions.implies(permission)) {
            return false;
        }
        return this.securityAdmin.checkPermission(permission, this);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void clearPermissionCache() {
        if (this.impliedPermissions != null) {
            this.impliedPermissions.clearPermissionCache();
        }
        if (this.restrictedPermissions != null) {
            this.restrictedPermissions.clearPermissionCache();
        }
    }
}

