/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.io.IOException;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.xfer.TransferListener;
import org.slf4j.Logger;

public class LoggingTransferListener
implements TransferListener {
    private final LoggerFactory loggerFactory;
    private final Logger log;
    private final String relPath;

    public LoggingTransferListener(LoggerFactory loggerFactory) {
        this("", loggerFactory);
    }

    private LoggingTransferListener(String relPath, LoggerFactory loggerFactory) {
        this.relPath = relPath;
        this.loggerFactory = loggerFactory;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    @Override
    public TransferListener directory(String name) {
        this.log.debug("started transferring directory `{}`", (Object)name);
        return new LoggingTransferListener(this.relPath + name + "/", this.loggerFactory);
    }

    @Override
    public StreamCopier.Listener file(String name, final long size) {
        final String path = this.relPath + name;
        this.log.debug("started transferring file `{}` ({} bytes)", (Object)path, (Object)size);
        return new StreamCopier.Listener(){

            @Override
            public void reportProgress(long transferred) throws IOException {
                if (LoggingTransferListener.this.log.isTraceEnabled()) {
                    LoggingTransferListener.this.log.trace("transferred {}% of `{}`", (Object)(transferred * 100L / size), (Object)path);
                }
            }
        };
    }
}

