/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.SimpleCommandContext;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class NavigatorHandlerObjectBase
extends AbstractHandler {
    private static final Log log = Log.getLog(NavigatorHandlerObjectBase.class);
    static boolean updateUI = true;

    protected static CommandTarget getCommandTarget(IWorkbenchWindow workbenchWindow, DBNNode container, Class<?> childType, boolean openEditor) throws DBException {
        DBSObject object;
        DBEStructEditor parentStructEditor;
        Object parentObject = container instanceof DBNDatabaseNode ? ((DBNDatabaseNode)container).getValueObject() : null;
        DBSObject objectToSeek = null;
        if (parentObject instanceof DBSObject && (parentStructEditor = (DBEStructEditor)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(parentObject.getClass(), DBEStructEditor.class)) != null && RuntimeUtils.isTypeSupported(childType, (Class[])parentStructEditor.getChildTypes())) {
            objectToSeek = (DBSObject)parentObject;
        }
        if (objectToSeek != null) {
            IDatabaseEditor editor;
            IEditorReference[] iEditorReferenceArray = workbenchWindow.getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDatabaseEditorInput editorInput;
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor2 = editorRef.getEditor(false);
                if (editor2 instanceof IDatabaseEditor && (editorInput = ((IDatabaseEditor)editor2).getEditorInput()).getDatabaseObject() == objectToSeek) {
                    workbenchWindow.getActivePage().activate((IWorkbenchPart)editor2);
                    NavigatorHandlerObjectBase.switchEditorFolder(container, editor2);
                    return new CommandTarget((IDatabaseEditor)editor2);
                }
                ++n2;
            }
            if (openEditor && container instanceof DBNDatabaseNode && (editor = (IDatabaseEditor)NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)((DBNDatabaseNode)container), null, workbenchWindow)) != null) {
                NavigatorHandlerObjectBase.switchEditorFolder(container, (IEditorPart)editor);
                return new CommandTarget(editor);
            }
        }
        if (container instanceof DBNDatabaseNode && (object = ((DBNDatabaseNode)container).getObject()) != null) {
            return new CommandTarget((DBECommandContext)new SimpleCommandContext(DBUtils.getDefaultContext((DBSObject)object, (boolean)false), !openEditor));
        }
        return new CommandTarget();
    }

    private static void switchEditorFolder(DBNNode container, IEditorPart editor) {
        if (container instanceof DBNContainer && editor instanceof ITabbedFolderContainer && container instanceof DBNDatabaseFolder) {
            ((ITabbedFolderContainer)editor).switchFolder(((DBNDatabaseFolder)container).getChildrenType());
        }
    }

    public static DBNDatabaseNode getNodeByObject(DBSObject object) {
        DBNModel model = DBWorkbench.getPlatform().getNavigatorModel();
        DBNDatabaseNode node = model.findNode(object);
        if (node == null) {
            NodeLoader nodeLoader = new NodeLoader(model, Collections.singleton(object));
            try {
                UIUtils.runInProgressService((DBRRunnableWithProgress)nodeLoader);
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Can't load node for object '" + object.getName() + "'"), e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
            if (!nodeLoader.nodes.isEmpty()) {
                node = (DBNDatabaseNode)nodeLoader.nodes.get(0);
            }
        }
        return node;
    }

    public static Collection<DBNDatabaseNode> getNodesByObjects(Collection<Object> objects) {
        DBNModel model = DBWorkbench.getPlatform().getNavigatorModel();
        ArrayList<DBNDatabaseNode> result = new ArrayList<DBNDatabaseNode>();
        ArrayList<Object> missingObjects = new ArrayList<Object>();
        for (Object object : objects) {
            DBNDatabaseNode node;
            if (object instanceof DBSObject && (node = model.findNode((DBSObject)object)) != null) {
                result.add(node);
                continue;
            }
            missingObjects.add(object);
        }
        if (!missingObjects.isEmpty()) {
            NodeLoader nodeLoader = new NodeLoader(model, missingObjects);
            try {
                UIUtils.runInProgressService((DBRRunnableWithProgress)nodeLoader);
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Can't load node for objects " + missingObjects.size()), e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
            result.addAll(nodeLoader.nodes);
        }
        return result;
    }

    protected static boolean showScript(IWorkbenchWindow workbenchWindow, DBECommandContext commandContext, Map<String, Object> options, String dialogTitle) {
        Collection commands = commandContext.getFinalCommands();
        StringBuilder script = new StringBuilder();
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    for (DBECommand command : commands) {
                        DBEPersistAction[] persistActions = command.getPersistActions(monitor, options);
                        script.append(SQLUtils.generateScript((DBPDataSource)commandContext.getExecutionContext().getDataSource(), (DBEPersistAction[])persistActions, (boolean)false));
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Script generation error", "Error generating alter script", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            return serviceSQL.openSQLViewer(commandContext.getExecutionContext(), dialogTitle, (DBPImage)UIIcon.SQL_PREVIEW, script.toString(), true) == 10;
        }
        return false;
    }

    protected static class CommandTarget {
        private DBECommandContext context;
        private IDatabaseEditor editor;

        private CommandTarget() {
        }

        private CommandTarget(DBECommandContext context) {
            this.context = context;
        }

        public CommandTarget(IDatabaseEditor editor) {
            this.editor = editor;
            this.context = editor.getEditorInput().getCommandContext();
        }

        public DBECommandContext getContext() {
            return this.context;
        }

        public IDatabaseEditor getEditor() {
            return this.editor;
        }
    }

    private static class NodeLoader
    implements DBRRunnableWithProgress {
        private final DBNModel model;
        private final Collection<? extends Object> objects;
        private List<DBNDatabaseNode> nodes;

        public NodeLoader(DBNModel model, Collection<? extends Object> objects) {
            this.model = model;
            this.objects = objects;
            this.nodes = new ArrayList<DBNDatabaseNode>(objects.size());
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            for (Object object : this.objects) {
                DBSObject structObject;
                block6: {
                    if (object instanceof DBSObject) {
                        structObject = (DBSObject)object;
                    } else {
                        if (object instanceof DBSObjectReference) {
                            try {
                                structObject = ((DBSObjectReference)object).resolveObject(monitor);
                                break block6;
                            }
                            catch (DBException e) {
                                log.error((Object)"Can't resolve object reference", (Throwable)e);
                                continue;
                            }
                        }
                        log.warn((Object)("Unsupported object type: " + object));
                        continue;
                    }
                }
                DBNDatabaseNode node = this.model.getNodeByObject(monitor, structObject, true);
                if (node == null) continue;
                this.nodes.add(node);
            }
        }
    }

    protected static class ObjectSaver
    implements DBRRunnableWithProgress {
        private final DBECommandContext commander;
        private Map<String, Object> options;

        public ObjectSaver(DBECommandContext commander, Map<String, Object> options) {
            this.commander = commander;
            this.options = options;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
            try {
                this.commander.saveChanges(monitor, this.options);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

